#!/bin/bash
################################################################################
# Copyright (c) 2014 Elphel, Inc.
# This file is a part of VDT plug-in.
# VDT plug-in is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# VDT plug-in is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 
#  Additional permission under GNU GPL version 3 section 7:
# If you modify this Program, or any covered work, by linking or combining it
# with Eclipse or Eclipse plugins (or a modified version of those libraries),
# containing parts covered by the terms of EPL/CPL, the licensors of this
# Program grant you additional permission to convey the resulting work.
# {Corresponding Source for a non-source form of such a combination shall
# include the source code for the parts of Eclipse or Eclipse plugins used
# as well as that of the covered work.}
################################################################################

TMPDIR="tmp"
GITURL="https://github.com/Elphel/unmodified_veditor_1_2_0_clone.git"
GITREPO="unmodified_veditor_1_2_0_clone"
PATCH_FILE="vdt-veditor.patch"
INITIAL_DIRECTORY=`pwd`
if [ ! -d "$TMPDIR" ]; then
 mkdir "$TMPDIR"
fi

rm -f -v -r "$TMPDIR"/vdt "$TMPDIR"/vdt-veditor "$TMPDIR"/*.patch
mkdir -p "$TMPDIR"/vdt/src/com/elphel/vdt/core/launching
cp -v src/com/elphel/vdt/core/launching/VDTErrorParser.java "$TMPDIR"/vdt/src/com/elphel/vdt/core/launching
cp -v -r src/com/elphel/vdt/veditor "$TMPDIR"/vdt/src/com/elphel/vdt/
cp -v -r _generated "$TMPDIR"/vdt/
cp -v about_veditor.html "$TMPDIR"/vdt/
cp -v ChangeLogVeditor.txt "$TMPDIR"/vdt/
cp -v CONTRIBUTORS_VEDITOR.txt "$TMPDIR"/vdt/
cd "$TMPDIR"
if [ ! -d "$GITREPO" ]; then
 git clone "$GITURL"
fi	
mkdir -p vdt-veditor/src/com/elphel/vdt/core/launching
#Different structure of the files generated by JavaCC, manual copying
mkdir -p vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog
mkdir -p vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/JavaCharStream.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/ParseException.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/ParseException.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/Token.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/Token.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/TokenMgrError.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/TokenMgrError.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/VerilogParserCoreConstants.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/VerilogParserCore.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/VerilogParserCoreTokenManager.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/verilog/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/VhdlParserCoreConstants.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/VhdlParserCore.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl/
cp -v -r "$GITREPO"/_generated/net/sourceforge/veditor/parser/VhdlParserCoreTokenManager.java vdt-veditor/_generated/com/elphel/vdt/veditor/parser/vhdl/

cp -v "$GITREPO"/about.html vdt-veditor/about_veditor.html
cp -v "$GITREPO"/ChangeLog.txt vdt-veditor/ChangeLogVeditor.txt
cp -v "$GITREPO"/CONTRIBUTORS.txt vdt-veditor/CONTRIBUTORS_VEDITOR.txt
cp -v "$GITREPO"/src/net/sourceforge/veditor/builder/ErrorParser.java vdt-veditor/src/com/elphel/vdt/core/launching/VDTErrorParser.java

cp -v -r "$GITREPO"/src/net/sourceforge/veditor vdt-veditor/src/com/elphel/vdt/

find vdt-veditor -name ".svn" -exec rm -rf {} \;
#Ignore all white spaces
#diff -U 3 -H -w -d -r -N -x '.svn*' -- vdt-veditor vdt > "$PATCH_FILE"

diff -U 3 -dHrN -- vdt-veditor vdt > "$PATCH_FILE"

cp -v "$PATCH_FILE" "$INITIAL_DIRECTORY"
cd "$INITIAL_DIRECTORY"
pwd
exit 0
