/**
 **
 ** dtt8x8.cu - CPU test code to run GPU tile processor
 **
 ** Copyright (C) 2018 Elphel, Inc.
 **
 ** -----------------------------------------------------------------------------**
 **
 **  dtt8x8.cu is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **  Additional permission under GNU GPL version 3 section 7
 **
 **  If you modify this Program, or any covered work, by linking or
 **  combining it with NVIDIA Corporation's CUDA libraries from the
 **  NVIDIA CUDA Toolkit (or a modified version of those libraries),
 **  containing parts covered by the terms of NVIDIA CUDA Toolkit
 **  EULA, the licensors of this Program grant you additional
 **  permission to convey the resulting work.
 ** -----------------------------------------------------------------------------**
 */

// all of the next 5 were disabled
//#define NOCORR
//#define NOCORR_TD
//#define NOTEXTURES //
#define NOTEXTURE_RGBA //
//#define NOTEXTURE_RGBAXXX //


#define SAVE_CLT
#define NO_DP
#define CORR_INTER_SELF 1


#include <cstdlib>
#include <cstdio>
#include <cuda_runtime.h>     // cudaFree
//#define __CUDA_RUNTIME_H__  // turn on, then off to fix missing findCudaDevice()
#include <helper_cuda.h>      // for checkCudaErrors
#include <helper_functions.h> // timer functions

#include <math.h>
//#include <driver_types.h> // was not needed before, only for indexes - needs __DRIVER_TYPES_H__

// for reading binary files
#include <fstream>
#include <iterator>
#include <vector>


#include "tp_defines.h"   // was not here
#include "dtt8x8.h"
#include "geometry_correction.h"
#include "TileProcessor.h"
#include "tp_utils.h"
#include "tp_files.h"
#include "tp_paths.h"
#include "TpParams.h"
#include "TpHostGpu.h"

/**
**************************************************************************
*  Program entry point
*
* \param argc       [IN] - Number of command-line arguments
* \param argv       [IN] - Array of command-line arguments
*
* \return Status code
*/
int main(int argc, char **argv)
{
    printf("%s Starting...\n\n", argv[0]);
    printf("sizeof(float*)=%d\n",(int)sizeof(float*));
    //initialize CUDA
    findCudaDevice(argc, (const char **)argv);
    int image_dx =      2;
    int image_dy =      0;
    float fat_zero = 1000.0f; // 300.0f; // 30.0;
#if TEST_LWIR
    int use_lwir= 1;
#else
    int use_lwir= 0;
#endif
/*
   const int angles_offsets [4]  {
    		(int) (offsetof4(corr_vector, azimuth)),
    		(int) (offsetof4(corr_vector, tilt)),
    		(int) (offsetof4(corr_vector, roll)),
    		(int) (offsetof4(corr_vector, roll))};
*/
    TpParams  tpParams (use_lwir);
    TpPaths   tpPaths  (use_lwir);
    TpHostGpu tpHostGpu(tpParams,tpPaths);

    tpHostGpu.allTests(
			10,   // int num_runs,
			image_dx,   // int image_dx,                 // 2
			image_dy,   // int image_dy,                 // 0
			 0.0, // const float target_disparity, // DBG_DISPARITY == 0.0
			 0.0, // const float scale,            // 0.0
			 fat_zero, //			const float fat_zero,         // 1000.0
			 0,   // int quad_combine,
			 1,   // int use_dp,
			 0);  // int debug);
	exit(0);
}
