/*
 * TpParams.h
 *
 *  Created on: Mar 31, 2025
 *      Author: elphel
 */

#ifndef SRC_TPPARAMS_H_
#define SRC_TPPARAMS_H_
#include <math.h>
#include "dtt8x8.h"
#include "tp_defines.h"
#include "geometry_correction.h" // TP_TASK_TASK_*
#include "TileProcessor.h"
class TpParams{
public:
	static constexpr int tilesx =                   TILESX;
	static constexpr int tilesy =                   TILESY;
	static constexpr int tilesya =                  TILESYA;
	static constexpr int dtt_size =                 DTT_SIZE;
	static constexpr int dtt_size2 =                DTT_SIZE2;
	static constexpr int img_width =                IMG_WIDTH;
	static constexpr int img_height =               IMG_HEIGHT;
	static constexpr int kernels_hor =              KERNELS_HOR;
	static constexpr int kernels_vert =             KERNELS_VERT;

	static constexpr int rbyrdist_len =             RBYRDIST_LEN;
	static constexpr int tiles_per_block_geom =     TILES_PER_BLOCK_GEOM;
	//
	static constexpr int task_inter_en =            TASK_INTER_EN; //          10 // Task bit to enable interscene correlation
	static constexpr int task_corr_en =             TASK_CORR_EN;  //           9 // Task bit to enable intrascene correlation (pairs defined separately)
	static constexpr int task_text_en =             TASK_TEXT_EN;  //           8 // task bit to enable texture generation

	static constexpr int list_texture_bit =         LIST_TEXTURE_BIT; //        8 // 7 // bit to request texture calculation
    static constexpr int text_ntile_shift =         TEXT_NTILE_SHIFT; //        9 // 8 // tile number shift for texture calculation (will be different from CORR_NTILE_SHIFT!)
    static constexpr int task_texture_bits =        TASK_TEXTURE_BITS; //       TileProcessor.h

    static constexpr int corr_ntile_shift =         CORR_NTILE_SHIFT; // 8 // higher bits - number of a pair, other bits tile number

    static constexpr int corr_out_rad =             CORR_OUT_RAD; // 7
    //???
//    static constexpr int tp_task_size =        TASK_TEXTURE_BITS; //       TileProcessor.h
//    int tp_task_size =  TILESX * TILESY; // sizeof(ftask_data)/sizeof(float)/tpParams.task_size; // number of task tiles
    static constexpr int tp_tasks_size =       tilesx * tilesy; //

	static constexpr int tp_task_task_offset =      TP_TASK_TASK_OFFSET;//      0
	static constexpr int tp_task_txy_offset =       TP_TASK_TXY_OFFSET;//       1
	static constexpr int tp_task_disparity_offset = TP_TASK_DISPARITY_OFFSET;// 2
	static constexpr int tp_task_centerxy_offset =  TP_TASK_CENTERXY_OFFSET;//  3
	static constexpr int tp_task_scale_offset =     TP_TASK_SCALE_OFFSET;//     5
	static constexpr int tp_task_xy_offset =        TP_TASK_XY_OFFSET;//        6
//	static constexpr float fat_zero =               1000.0f; // 300.0f; // 30.0;

    static constexpr int convert_direct_indexing_threads =      CONVERT_DIRECT_INDEXING_THREADS; //
    static constexpr int convert_direct_indexing_threads_log2 = CONVERT_DIRECT_INDEXING_THREADS_LOG2; //

#ifdef DBG_TILE
	static constexpr int debug_tile{1};
	static constexpr int dbg_tile{DBG_TILE};
#else
	static constexpr int debug_tile{0};
	static constexpr int dbg_tile{-1};
#endif

private:
	static constexpr int m_num_cams_lwir =   16; // refactor to s_
	static constexpr int m_num_colors_lwir =  1;
	static constexpr int m_num_pairs_lwir = 120;
	static constexpr int m_num_cams_rgb =     4;
	static constexpr int m_num_colors_rgb =   3;
	static constexpr int m_num_pairs_rgb =    6;
	static constexpr unsigned int m_sel_pairs_lwir[4] = {0xffffffff,0xffffffff,0xffffffff,0x00ffffff};
	static constexpr unsigned int m_sel_pairs_rgb[4] =  {0x3f,0,0,0};
	static constexpr int max_num_cams {std::max(m_num_cams_rgb,m_num_cams_lwir)}; // it is always 16 element, RGB uses only first 4
public:
	TpParams(int lwir);
	int     m_lwir;
	float   color_weights[3]{};
	float   generate_RBGA_params[5]{};
    int     num_cams{};
    int     num_colors{};
    int     num_pairs{};
    const unsigned int   * sel_pairs{};
    int     task_size;
    float port_offsets4[4][2] {// used only in textures to scale differences
			{-0.5, -0.5},
			{ 0.5, -0.5},
			{-0.5,  0.5},
			{ 0.5,  0.5}};

    // Could not make it variable port_offsets[?][2], 16 is maximal size

    float port_offsets[max_num_cams][2]; // [NUM_CAMS][2];
    int keep_texture_weights {3}; // 0; // 1; // try with 0 also
    int texture_colors{}; // 3; // result will be 3+1 RGBA (for mono - 2)
    int kern_tiles{};
    int kern_size{};
    int num_tiles{};
	int corr_size{};
    int corr_length{};
//    int num_corr_indices{}; // removing - different length for intra/inter
//    std::vector<float[2]> m_port_offsets;


private:
    float  m_color_weights_lwir[3] = {
    		1.0f,          // float             weight0,            // scale for R 0.5 / (1.0 + 0.5 +0.2)
			1.0f,          // float             weight1,            // scale for B 0.2 / (1.0 + 0.5 +0.2)
			1.0f};         // float             weight2,            // scale for G 1.0 / (1.0 + 0.5 +0.2)
    float  m_generate_RBGA_params_lwir[5] = {
    		10.0f,         // float             min_shot,           // 10.0
			3.0f,          // float             scale_shot,         // 3.0
			10.0f, // 1.5f,// float             diff_sigma,         // pixel value/pixel change
			10.0f,         // float             diff_threshold,     // pixel value/pixel change
			12.0f}; // 3.0 // float             min_agree,          // minimal number of channels to agree on a point (real number to work with fuzzy averages)
    float m_color_weights_rgb [3] = {
    		0.294118f,     // float             weight0,            // scale for R 0.5 / (1.0 + 0.5 +0.2)
			0.117647f,     // float             weight1,            // scale for B 0.2 / (1.0 + 0.5 +0.2)
			0.588235f};    // float             weight2,            // scale for G 1.0 / (1.0 + 0.5 +0.2)
    float m_generate_RBGA_params_rgb[5] = {
    		10.0f,         // float             min_shot,           // 10.0
			3.0f,          // float             scale_shot,         // 3.0
			1.5f,          // float             diff_sigma,         // pixel value/pixel change
			10.0f,         // float             diff_threshold,     // pixel value/pixel change
			3.0f};         // float             min_agree,          // minimal number of channels to agree on a point (real number to work with fuzzy averages)
};
#endif /* SRC_TPPARAMS_H_ */
