/*
 * tp_utils.h
 *
 *  Created on: Mar 25, 2025
 *      Author: elphel
 */

#ifndef SRC_TP_UTILS_H_
#define SRC_TP_UTILS_H_
float * copyalloc_kernel_gpu(float * kernel_host,
		                int size, // size in floats
						int full_size);

float * copyalloc_kernel_gpu(float * kernel_host,
		                int size);

float * alloccopy_from_gpu(
		float * gpu_data,
		float * cpu_data, // if null, will allocate
		int size);

float * alloc_kernel_gpu(int size); // size in floats

float ** copyalloc_pointers_gpu(float ** gpu_pointer,
		                int size); // number of entries (cameras)

// image-related
// shift image in-place, repeat lines/columns
void shift_image (
		float * image,
        int width,
		int height,
		int bayer,
		int dx,
		int dy);

void update_image_gpu(
		float * image_host,
		float * image_gpu,
		size_t  dstride, // in floats !
		int     width,
		int     height);

float * copyalloc_image_gpu(
		float * image_host,
		size_t* dstride, // in floats !
		int width,
		int height);

float * alloc_image_gpu(size_t* dstride, // in bytes!!
		                int width,
						int height);

// Prepare low pass filter (64 long) to be applied to each quadrant of the CLT data
void set_clt_lpf(
		float * lpf,    // size*size array to be filled out
		float   sigma,
		const int     dct_size);

int host_get_textures_shared_size( // in bytes
//__device__ int get_textures_shared_size( // in bytes
	    int                num_cams,     // actual number of cameras
	    int                num_colors,   // actual number of colors: 3 for RGB, 1 for LWIR/mono
		int *              offsets);    // in floats


#endif /* SRC_TP_UTILS_H_ */
