/*
 * tp_paths.h
 *
 *  Created on: Mar 26, 2025
 *      Author: elphel
 */

#ifndef SRC_TP_PATHS_H_
#define SRC_TP_PATHS_H_

class TpPaths{
public:
	    TpPaths(int lwir);
	    int    m_lwir;

	    const char ** kernel_file;
		const char ** kernel_offs_file;
		const char ** image_files;
		const char ** ports_offs_xy_file;
		const char ** ports_clt_file;
		const char ** result_rbg_file;

		const char* result_corr_file;
		const char* result_corr_quad_file;
		const char* result_corr_td_norm_file;
		const char* result_inter_td_norm_file;
		const char* result_textures_file;
		const char* result_diff_rgb_combo_file;
		const char* result_textures_rgba_file;
		const char* result_textures_file_dp;
		const char* result_diff_rgb_combo_file_dp;
		const char* result_textures_rgba_file_dp;
		const char* rByRDist_file;
		const char* correction_vector_file;
		const char* geometry_correction_file;
		const char* result_interscene_td =      "clt/aux_interscene-TD.raw";
		const char* result_intrascene_td =      "clt/aux_intrascene-TD.raw";
		const char* result_interscene_indices = "clt/aux_inter-indices.raw";

private:
	    const char * m_kernel_file_lwir[16] ={
	    		"clt/aux_chn0_transposed.kernel",
				"clt/aux_chn1_transposed.kernel",
				"clt/aux_chn2_transposed.kernel",
				"clt/aux_chn3_transposed.kernel",
				"clt/aux_chn4_transposed.kernel",
				"clt/aux_chn5_transposed.kernel",
				"clt/aux_chn6_transposed.kernel",
				"clt/aux_chn7_transposed.kernel",
				"clt/aux_chn8_transposed.kernel",
				"clt/aux_chn9_transposed.kernel",
				"clt/aux_chn10_transposed.kernel",
				"clt/aux_chn11_transposed.kernel",
				"clt/aux_chn12_transposed.kernel",
				"clt/aux_chn13_transposed.kernel",
				"clt/aux_chn14_transposed.kernel",
				"clt/aux_chn15_transposed.kernel"};
	    const char * m_kernel_offs_file_lwir[16] = {
	    		"clt/aux_chn0_transposed.kernel_offsets",
				"clt/aux_chn1_transposed.kernel_offsets",
				"clt/aux_chn2_transposed.kernel_offsets",
				"clt/aux_chn3_transposed.kernel_offsets",
				"clt/aux_chn4_transposed.kernel_offsets",
				"clt/aux_chn5_transposed.kernel_offsets",
				"clt/aux_chn6_transposed.kernel_offsets",
				"clt/aux_chn7_transposed.kernel_offsets",
				"clt/aux_chn8_transposed.kernel_offsets",
				"clt/aux_chn9_transposed.kernel_offsets",
				"clt/aux_chn10_transposed.kernel_offsets",
				"clt/aux_chn11_transposed.kernel_offsets",
				"clt/aux_chn12_transposed.kernel_offsets",
				"clt/aux_chn13_transposed.kernel_offsets",
				"clt/aux_chn14_transposed.kernel_offsets",
				"clt/aux_chn15_transposed.kernel_offsets"};
	    const char * m_image_files_lwir[16]= {
	    		"clt/aux_chn0.bayer",
				"clt/aux_chn1.bayer",
				"clt/aux_chn2.bayer",
				"clt/aux_chn3.bayer",
				"clt/aux_chn4.bayer",
				"clt/aux_chn5.bayer",
				"clt/aux_chn6.bayer",
				"clt/aux_chn7.bayer",
				"clt/aux_chn8.bayer",
				"clt/aux_chn9.bayer",
				"clt/aux_chn10.bayer",
				"clt/aux_chn11.bayer",
				"clt/aux_chn12.bayer",
				"clt/aux_chn13.bayer",
				"clt/aux_chn14.bayer",
				"clt/aux_chn15.bayer"};
	    const char * m_ports_offs_xy_file_lwir[16]= {
	    		"clt/aux_chn0.portsxy",
				"clt/aux_chn1.portsxy",
				"clt/aux_chn2.portsxy",
				"clt/aux_chn3.portsxy",
				"clt/aux_chn4.portsxy",
				"clt/aux_chn5.portsxy",
				"clt/aux_chn6.portsxy",
				"clt/aux_chn7.portsxy",
				"clt/aux_chn8.portsxy",
				"clt/aux_chn9.portsxy",
				"clt/aux_chn10.portsxy",
				"clt/aux_chn11.portsxy",
				"clt/aux_chn12.portsxy",
				"clt/aux_chn13.portsxy",
				"clt/aux_chn14.portsxy",
				"clt/aux_chn15.portsxy"};
	    const char * m_ports_clt_file_lwir[16]= { // never referenced
	    		"clt/aux_chn0.clt",
				"clt/aux_chn1.clt",
				"clt/aux_chn2.clt",
				"clt/aux_chn3.clt",
				"clt/aux_chn4.clt",
				"clt/aux_chn5.clt",
				"clt/aux_chn6.clt",
				"clt/aux_chn7.clt",
				"clt/aux_chn8.clt",
				"clt/aux_chn9.clt",
				"clt/aux_chn10.clt",
				"clt/aux_chn11.clt",
				"clt/aux_chn12.clt",
				"clt/aux_chn13.clt",
				"clt/aux_chn14.clt",
				"clt/aux_chn15.clt"};
	    const char * m_result_rbg_file_lwir[16] = {
	    		"clt/aux_chn0.rbg",
				"clt/aux_chn1.rbg",
				"clt/aux_chn2.rbg",
				"clt/aux_chn3.rbg",
				"clt/aux_chn4.rbg",
				"clt/aux_chn5.rbg",
				"clt/aux_chn6.rbg",
				"clt/aux_chn7.rbg",
				"clt/aux_chn8.rbg",
				"clt/aux_chn9.rbg",
				"clt/aux_chn10.rbg",
				"clt/aux_chn11.rbg",
				"clt/aux_chn12.rbg",
				"clt/aux_chn13.rbg",
				"clt/aux_chn14.rbg",
				"clt/aux_chn15.rbg"};

	    const char * m_kernel_file_rgb[4] = {
	    		"clt/main_chn0_transposed.kernel",
				"clt/main_chn1_transposed.kernel",
				"clt/main_chn2_transposed.kernel",
				"clt/main_chn3_transposed.kernel"};
	    const char * m_kernel_offs_file_rgb[4] = {
	    		"clt/main_chn0_transposed.kernel_offsets",
				"clt/main_chn1_transposed.kernel_offsets",
				"clt/main_chn2_transposed.kernel_offsets",
				"clt/main_chn3_transposed.kernel_offsets"};
	    const char * m_image_files_rgb[4] = {
	    		"clt/main_chn0.bayer",
				"clt/main_chn1.bayer",
				"clt/main_chn2.bayer",
				"clt/main_chn3.bayer"};
	    const char * m_ports_offs_xy_file_rgb[4] = {
	    		"clt/main_chn0.portsxy",
				"clt/main_chn1.portsxy",
				"clt/main_chn2.portsxy",
				"clt/main_chn3.portsxy"};
	    const char * m_ports_clt_file_rgb[4] = { // never referenced
	    		"clt/main_chn0.clt",
				"clt/main_chn1.clt",
				"clt/main_chn2.clt",
				"clt/main_chn3.clt"};
	    const char * m_result_rbg_file_rgb[4] = {
	    		"clt/main_chn0.rbg",
				"clt/main_chn1.rbg",
				"clt/main_chn2.rbg",
				"clt/main_chn3.rbg"};
};

#endif /* SRC_TP_PATHS_H_ */
