/*
 * TpParams.cu
 *
 *  Created on: Mar 31, 2025
 *      Author: elphel
 */
#include <math.h>
#include "tp_defines.h"   // was not here
#include "geometry_correction.h"
#include "TpParams.h"
TpParams::TpParams(int lwir){
	m_lwir = lwir;
	for (int i = 0; i < sizeof(color_weights)/sizeof(color_weights[0]); i++) {
		color_weights[i] =              lwir? m_color_weights_lwir[i] :        m_color_weights_rgb[i];
	}
	for (int i = 0; i < sizeof(generate_RBGA_params)/sizeof(generate_RBGA_params[0]); i++) {
		generate_RBGA_params[i] =       lwir? m_generate_RBGA_params_lwir[i] : m_generate_RBGA_params_rgb[i];
	}
	num_cams =                   lwir? m_num_cams_lwir :             m_num_cams_rgb;
	num_colors =                 lwir? m_num_colors_lwir :           m_num_colors_rgb;
	num_pairs =                  lwir? m_num_pairs_lwir :            m_num_pairs_rgb;
	sel_pairs =                  lwir? m_sel_pairs_lwir :            m_sel_pairs_rgb;
	task_size = get_task_size(num_cams); // sizeof(struct tp_task)/sizeof(float) - 6 * (NUM_CAMS - num_cams);
    if (num_cams == 4){
    	for (int ncam = 0; ncam < 4; ncam++){
    		port_offsets[ncam][0]= port_offsets4[ncam][0];
    		port_offsets[ncam][1]= port_offsets4[ncam][1];
    	}
    } else {
		 for (int ncam = 0; ncam < num_cams; ncam++) {
			 double alpha = 2 * M_PI * (ncam) /num_cams; // math.h
			 port_offsets[ncam][0] =  0.5 * sin((alpha));
			 port_offsets[ncam][1] = -0.5 * cos((alpha));
		 }
    }
    texture_colors = num_colors; // 3; // result will be 3+1 RGBA (for mono - 2)
    kern_tiles = KERNELS_HOR *  KERNELS_VERT * num_colors; // NUM_COLORS;
    kern_size =  kern_tiles * 4 * 64;
	corr_size =  2 * corr_out_rad + 1;
	corr_length =  corr_size * corr_size;
    num_tiles =  tp_tasks_size;
//    num_corr_indices = num_pairs * num_tiles;
}


