/*
 * tp_files.cu
 *
 *  Created on: Mar 25, 2025
 *      Author: elphel
 */

//#include <cuda_runtime.h>
//#include <helper_cuda.h>
//#include <stdio.h>
//#include <stdlib.h>

//#include <fstream>
//#include <iterator>
//#include <vector>
//#include "tp_utils.h"


#include "tp_files.h"
int get_file_size(const std::string filename) // path to file
{
    FILE *p_file = NULL;
    p_file = fopen(filename.c_str(),"rb");
    fseek(p_file,0,SEEK_END);
    int size = ftell(p_file);
    fclose(p_file);
    return size;
}

int readFloatsFromFile(float *       data, // allocated array
					   const char *  path) // file path
{
    printf("readFloatsFromFile(%s)\n", path);

    int fsize = get_file_size(path);
    std::ifstream input(path, std::ios::binary );
    // copies all data into buffer
    std::vector<char> buffer((
            std::istreambuf_iterator<char>(input)),
            (std::istreambuf_iterator<char>()));
    std::copy( buffer.begin(), buffer.end(), (char *) data);
    printf("---- Bytes read: %d from %s\n", fsize, path);
	return 0;
}



float * readAllFloatsFromFile(const char *  path,
		int * len_in_floats) //
{
    int fsize = get_file_size(path);
    float * data = (float *) malloc(fsize);
    std::ifstream input(path, std::ios::binary );
    std::vector<char> buffer((
            std::istreambuf_iterator<char>(input)),
            (std::istreambuf_iterator<char>()));
    std::copy( buffer.begin(), buffer.end(), (char *) data);
    printf("---- Bytes read: %d from %s\n", fsize, path);
    * len_in_floats = fsize/sizeof(float);
    return data;
}

int writeFloatsToFile(float *       data, // allocated array
		               int           size, // length in elements
					   const char *  path) // file path
{

	std::ofstream ofile(path, std::ios::binary);
	ofile.write((char *) data, size * sizeof(float));
	return 0;
}

/*
int readFloatsFromFile(float *           data, // allocated array
					   const std::string path) // file path
{
    printf("readFloatsFromFile(%s)\n", path);

    int fsize = get_file_size(path);
    std::ifstream input(path, std::ios::binary );
    // copies all data into buffer
    std::vector<char> buffer((
            std::istreambuf_iterator<char>(input)),
            (std::istreambuf_iterator<char>()));
    std::copy( buffer.begin(), buffer.end(), (char *) data);
    printf("---- Bytes read: %d from %s\n", fsize, path);
	return 0;
}

float * readAllFloatsFromFile(const std::string path,
		int * len_in_floats) //
{
    int fsize = get_file_size(path);
    float * data = (float *) malloc(fsize);
    std::ifstream input(path, std::ios::binary );
    std::vector<char> buffer((
            std::istreambuf_iterator<char>(input)),
            (std::istreambuf_iterator<char>()));
    std::copy( buffer.begin(), buffer.end(), (char *) data);
    printf("---- Bytes read: %d from %s\n", fsize, path);
    * len_in_floats = fsize/sizeof(float);
    return data;
}

int writeFloatsToFile(float *           data, // allocated array
		               int              size, // length in elements
					   const std::string path) // file path
{
	std::ofstream ofile(path, std::ios::binary);
	ofile.write((char *) data, size * sizeof(float));
	return 0;
}

*/

