macro "fiji_get_points" {
  saveSettings;
  s = selectionType();
    if ( s == -1 ) {
        exit("There was no selection.");
    } else if( s != 10 ) {
        exit("The selection wasn't a point selection.");
    } else {
        getSelectionCoordinates(xPoints,yPoints);
        x = xPoints[0];
        y = yPoints[0];
        showMessage("Got coordinates ("+x+","+y+")");
        showMessage("Got points:" + xPoints.length);
        for (i = 0; i < xPoints.length; i++){
          print (i, xPoints[i], yPoints[i]); 
        }
        
    }

  /*
  
  2180, 2428 -16: 2164, 2412
  3441, 2561
  6: 2185, 2431 ( 2180, 2427 - offsest by 5?
  7: 2175, 3351
  2299, 3241
  template_dir="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching";
  template_file="object3_black_half_7-24x24.tiff";
  soure_dir="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/exported_layers_on_grey";
  scoremaps_directory="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/scoremaps";
  suffix="-scoremap";
  
  create_scoremap("L3-1691017288_801308.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017293_032075.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017286_416693.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017285_820540.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017285_262848.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017284_609002.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017284_070541.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017283_609002.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  function create_scoremap (src_file, template, template_dir, src_dir, score_dir, suffix) {
    open(template_dir+"/"+template);
    selectImage(template);
    open(src_dir+"/"+src_file);
    selectImage(src_file);
    source_width=getWidth();
    source_height=getHeight();
    run("32-bit");
    run("Subtract...", "value=128");
    run("Wi8dow/Level...");
    run("Enhance Contrast", "saturated=0.35");
    run("Compute ScoreMap", "template="+template+" image=" + src_file+" method=[Normalised cross-correlation] score_threshold=0.9");
    close(); // thresholded result
    run("Canvas Size...", "width="+source_width+" height="+source_height+" position=Center zero");
    saveAs("Tiff", score_dir + "/"+src_file+suffix+".tiff");
    close(); // saved result
    close(); // source file
    close(); // template file
  }
  */
  restoreSettings;
}
// /home/elphel/git/imagej-elphel/ij_macros/fiji_scoremaps.txt 
