package com.elphel.imagej.orthomosaic;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

import ij.Prefs;

public class AltitudeMismatchKernel implements Serializable{
	private static final long serialVersionUID = 1L;	
	public static String kernels_directory;
	public int    zoom_level;
	public double agl_from;
	public double agl_to;
	public String filename;
	public AltitudeMismatchKernel (
			String filename,
			int zoom_level,
			double agl_from,
			double agl_to) {
		this.filename =   filename;
		this.zoom_level = zoom_level;
		this.agl_from =   agl_from;
		this.agl_to =     agl_to;
	}
	private void writeObject(ObjectOutputStream oos) throws IOException {
		oos.defaultWriteObject();
	}
	private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
		ois.defaultReadObject();
	}

	public static void setKernelsDirectory(
			String directory) {
		while (directory.endsWith(Prefs.getFileSeparator())){
			directory=directory.substring(0, directory.length()-1);
		}
		kernels_directory = directory;
	}
	public static String getKernelsDirectory() {
		return kernels_directory;
	}
	
	public String getKernelPath() {
		return kernels_directory+Prefs.getFileSeparator()+filename;
	}
	
	public static AltitudeMismatchKernel getKernel(
			int                               zoom_level,
			double                            agl_from,
			double                            agl_to,
			ArrayList<AltitudeMismatchKernel> kernels) {
		double tolerance = 0.15;
		double agl_from_min = agl_from * (1.0 - tolerance);
		double agl_from_max = agl_from * (1.0 + tolerance);
		double agl_to_min = agl_to * (1.0 - tolerance);
		double agl_to_max = agl_to * (1.0 + tolerance);
		for (AltitudeMismatchKernel kernel:kernels) {
			if (zoom_level == kernel.zoom_level) {
				if (    (kernel.agl_from >= agl_from_min) &&
						(kernel.agl_from <= agl_from_max) &&
						(kernel.agl_to >= agl_to_min) &&
						(kernel.agl_to <= agl_to_max))
				return kernel;
			}
		}
		return null;
	}

}
