package com.elphel.imagej.mcp;

import java.util.concurrent.atomic.AtomicReference;

public class McpDialogRegistry {
    private static final AtomicReference<McpDialogSession> CURRENT = new AtomicReference<McpDialogSession>(null);

    private McpDialogRegistry() {
    }

    public static void setCurrent(McpDialogSession session) {
        CURRENT.set(session);
    }

    public static McpDialogSession getCurrent() {
        return CURRENT.get();
    }

    public static void setValue(String label, String value) {
        McpDialogSession session = CURRENT.get();
        if (session == null) {
            return;
        }
        session.setValue(label, value);
    }
}
