package com.elphel.imagej.orthomosaic;

public class Affine2Import {
	public static final String AFFINE2_TAG = "AFFINE2";	
	public static final int    AFFINE2_LEN = 10;
	public String name1;
	public String name2;
	public double overlap;
	public double [][] affine;
	public static boolean matches(String [] tokens) {
		return ((tokens.length == AFFINE2_LEN) && AFFINE2_TAG.equals(tokens[0]));
	}
	public Affine2Import(
			String [] tokens) {
		if (!matches(tokens)) {
			throw new IllegalArgumentException ("Not Affine2Import tokens");
		}
		int indx = 1;
		name1 = tokens[indx++];
		name2 = tokens[indx++];
		overlap = Double.parseDouble(tokens[indx++]);
		affine = new double [2][3];
		for (int i = 0; i < affine.length; i++) {
			for (int j = 0; j < affine[i].length; j++) {
				affine[i][j] = Double.parseDouble(tokens[indx++]);
			}
		}
	}
}
