package com.elphel.imagej.correction;

import java.util.concurrent.atomic.AtomicInteger;

import com.elphel.imagej.common.GenericJTabbedDialog;

public class SyncCommand {
	public static final int STOP_NO =         0;
	public static final int STOP_ASAP =       1;
	public static final int STOP_CONVENIENT = 2;
	public boolean isRunning = false;
	public AtomicInteger stopRequested = new AtomicInteger(0); // 0 - not requested, 1 - ASAP, 2 - gracefully
	public String buttonLabel = "";
	public boolean confirm = true;
	
	public boolean interruptCommand() {
		boolean asap = false;
		GenericJTabbedDialog gd = new GenericJTabbedDialog("Interrupt Command",600,300);
		gd.addCheckbox ("Ask for confirmation",                              this.confirm,
				"If checked, program will pause at a checkpoint allowing to cancel the stop request and continue.");
		gd.addCheckbox ("ASAP",                                              asap,
				"Stop ASAP.  If uncheked, stop at more convenient stage.");
		gd.showDialog();
		if (gd.wasCanceled()) 
			return false;
		this.confirm=               gd.getNextBoolean();
		this.stopRequested.set(gd.getNextBoolean() ? STOP_ASAP : STOP_CONVENIENT );
		return true;
	}
	public boolean stopNow(boolean convenient) {
		if (stopRequested.get()==STOP_NO){
			return false;
		}
		//if (stopRequested.get() ==)
		if (!convenient && (stopRequested.get()==STOP_CONVENIENT)) {
			return false;
		}
		if (!confirm) {
			return true;
		}
		GenericJTabbedDialog gd = new GenericJTabbedDialog("Stop requested, "+(convenient?"convenient point":"ASAP point"),600,300);
		gd.addMessage ("OK to stop, Cancel to continue");
		stopRequested.set(STOP_NO); // reset pending stop in any case.
		gd.showDialog();
		if (gd.wasCanceled()) 
			return false;
		return true;
	}
}