macro "fiji_scoremaps" {
  saveSettings;
  template_dir="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching";
//template_file= "object3_black_half_7-24x24.tiff"; // blurred
//  template_file="object3_black_48_gb5-0.33_32x32.tiff"; // sharper circle
// template_file="object3_black_48-0.33_32x32.tiff"; // sharp circle
  template_file="object4_black_48_gb8-0.333-UM5-0.9-48x48.tiff"; // with unsharp mask
  
  soure_dir="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/exported_layers_on_grey";
//  scoremaps_directory="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/scoremaps";
//  scoremaps_directory="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/scoremaps_medium";
//  scoremaps_directory="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/scoremaps_sharp";
   scoremaps_directory="/media/elphel/SSD3-4GB/lwir16-proc/berdich/annotations/collages/pattern-matching/scoremaps_UM5-0.9
  suffix="-scoremap";
  File.makeDirectory(scoremaps_directory); 

  create_scoremap("L3-1691017293_032075-7285_82.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017293_032075-7285_82-rot-shift.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017288_801308.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017293_032075.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017286_416693.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017285_820540.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017285_262848.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017284_609002.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017284_070541.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  create_scoremap("L3-1691017283_609002.jpeg", template_file, template_dir, soure_dir, scoremaps_directory, suffix);
  function create_scoremap (src_file, template, template_dir, src_dir, score_dir, suffix) {
    open(template_dir+"/"+template);
    selectImage(template);
    open(src_dir+"/"+src_file);
    selectImage(src_file);
    source_width=getWidth();
    source_height=getHeight();
    run("32-bit");
    run("Subtract...", "value=128");
    run("Window/Level...");
    run("Enhance Contrast", "saturated=0.35");
    run("Compute ScoreMap", "template="+template+" image=" + src_file+" method=[Normalised cross-correlation] score_threshold=0.9");
    close(); // thresholded result
    run("Canvas Size...", "width="+source_width+" height="+source_height+" position=Center zero");
    saveAs("Tiff", score_dir + "/"+src_file+suffix+".tiff");
    close(); // saved result
    close(); // source file
    close(); // template file
  }
  
  restoreSettings;
}
// /home/elphel/git/imagej-elphel/ij_macros/fiji_scoremaps.txt 
