macro "make_snapshots" {
  saveSettings;
  // copy lines to match required objects and put actual coordinates/names
  // (no spaces) below using kate's  <cntrl><shift>b mode
  // To run - open file in imagej, go to Plugins->Macros->Run and select this file (should have .txt extension)
  //
  subdir = "objects"
  Dialog.create("objects snapshots "); // ("Go to selected coordinates. Creates rectangular selection" );
  Dialog.addString("Subdirectory name",subdir);
  Dialog.show();
  subdir = Dialog.getString();
  
  makeSnapshot( 2456, 6458 , 150, 150, "_M", subdir);
  makeSnapshot( 4790, 9484 , 150, 150, "01", subdir);
  makeSnapshot( 4624, 10291, 150, 150, "02", subdir);
  makeSnapshot( 4642, 12968, 150, 150, "03", subdir);
  makeSnapshot( 4734, 11946, 150, 150, "04", subdir);
  makeSnapshot( 5266, 11618, 150, 150, "05", subdir);
  makeSnapshot( 4865, 5362 , 150, 150, "06", subdir);
  makeSnapshot( 4805, 7027 , 150, 150, "07", subdir);
  makeSnapshot( 4791, 8698 , 150, 150, "08", subdir);
  makeSnapshot( 4358, 5972 , 150, 150, "09", subdir);
  makeSnapshot( 4785, 12213, 150, 150, "10", subdir);
  makeSnapshot( 5620, 11280, 150, 150, "11", subdir);

    function makeSnapshot(xc, yc, width, height, suffix, subdir) {
        base_directory=getInfo("image.directory");
        directory = base_directory+"/"+subdir;
        filename=getInfo("image.filename")+"-"+suffix;
        makeRectangle(xc-width/2, yc-height/2, width, height);
        run("Duplicate...", " ");
        print("saving object snapshot to: "+  directory+"/"+filename+"-"+xc+"_"+yc+"_"+width+"_"+height+".tiff");
        File.makeDirectory(directory); 
        saveAs("Tiff", directory+"/"+filename+"-"+xc+"_"+yc+"_"+width+"_"+height+".tiff");
        saveAs("Jpeg", directory+"/"+filename+"-"+xc+"_"+yc+"_"+width+"_"+height+".jpeg");
        close();
    }
  restoreSettings;
}

