# Codex + Eclipse Installation (Kubuntu 24.04)

This document describes a known-working setup for using OpenAI Codex CLI
alongside Eclipse on Kubuntu 24.04, with Codex launched from Eclipse in a real
terminal (Konsole).

## Prerequisites
- Kubuntu 24.04
- Eclipse (any recent version)
- Git
- Node.js + npm (user-level install, no sudo)
- Konsole (default KDE terminal)

## npm installation with nvm

    sudo apt install curl
    curl -fsSL https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.7/install.sh | bash
    source ~/.bashrc

    nvm install --lts
    nvm use --lts
### Verify npm installation

    which node
    # should be ~/.nvm/versions/node/...

    npm config get prefix
    # should point inside ~/.nvm

## 1. Install Codex CLI (user-local)

Do NOT use sudo.

    npm install -g @openai/codex

Verify:

    which codex
    codex --version

The path should be under your home directory (for example ~/.npm-global/bin/codex).

## 2. Authenticate Codex

Run:

    codex

- Select “Sign in with ChatGPT” using the keyboard
- Open the provided link in a normal Firefox window
- Complete login
- Exit Codex with Ctrl+D

Authentication is stored locally; this is done once per machine.

## 3. Create a launcher script in the repo

In the root of your Git repository:

    mkdir -p tools
    cat > tools/run-codex.sh <<'EOF'
    #!/usr/bin/env bash
    exec /FULL/PATH/TO/codex
    EOF
    chmod +x tools/run-codex.sh

Replace /FULL/PATH/TO/codex with the output of `which codex`
(for example /home/elphel/.npm-global/bin/codex).

This avoids PATH issues when launching from Eclipse.

## 4. Configure Eclipse External Tool (Konsole)

In Eclipse:

Run → External Tools → External Tools Configurations…

Create a new Program configuration.

Main tab:
- Name: Codex
- Location: /usr/bin/konsole
- Working Directory: Browse Workspace → select project root
- Arguments:

    --workdir  ${project_loc} -e bash -lc "./tools/run-codex.sh"

(Common tab: enable “Display in favorites menu → External Tools”.)

Apply and Run (the project where you plan to use Codex should be selected in the Project Explorer when you press Run).

If ~/.bashrc was just modified and Eclipse is launched without restarting the KDE session, this Run will fail.
The Eclipse Console will show <terminated>. You may run Eclipse from the terminal after

    source ~/.bashrc
    
or just logout/login and restart Eclipse.
To troubleshoot "<terminated>" problem you may modify Arguments in Eclipse launcher by adding "--hold":

    --hold --workdir  ${project_loc} -e bash -lc "./tools/run-codex.sh"
    

A Konsole window should open and display the Codex UI.

## 5. Add AGENTS.md (recommended)

Create AGENTS.md in the repo root:

    ## Build
    - mvn -DskipTests clean package

    ## Running
    - Prefer Eclipse Run/Debug configurations.
    - Do not invent CLI run commands.

    ## Scope
    - Make minimal, focused changes.
    - Ask before touching GPU/CUDA code.

Restart Codex after editing AGENTS.md.

## Daily workflow

1. Work in Eclipse
2. Launch Codex via Run → External Tools → Codex
3. Ask Codex to review or modify local code
4. Review changes in Eclipse
5. Commit and push

## Notes
- Codex requires a real terminal (TTY); always launch via Konsole
- Eclipse internal console will not work
- Codex rereads AGENTS.md on startup
- No /reload command exists; restart Codex instead
