# Project scripts

This file is generated from `scripts/catalog.json`.

## How to register a new script

1) Add an entry in `scripts/catalog.json` under `scripts`.
2) Run:

```bash
/home/elphel/git/imagej-elphel/scripts/catalog_to_md.py
```

---

## Docs

### mcp-http-howto.md

HTTP MCP endpoints and usage notes for controlling imagej-elphel via MCP.

Path: `scripts/mcp-http-howto.md`

### email_send.py

Send email via SSH+sendmail on community.elphel.com by default (set ELPHEL_SEND_MODE=smtp to force SMTP).

Path: `scripts/email_send.py`

### email_fetch.py

Fetch email via IMAP (mail.elphel.com) and save messages to files.

Path: `scripts/email_fetch.py`

---

## mcp_filter_list_by_model_version.py

Filter a .list file to keep only sequences with an existing model version subdir.

Path: `scripts/mcp_filter_list_by_model_version.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/mcp_filter_list_by_model_version.py /media/elphel/btrfs-data/lwir16-proc/NC/lists/nc_site.list v89
```

Inputs:
- MCP server (http://127.0.0.1:48888)
- list file path (required)
- model version (from MCP dialog or CLI argument)

Outputs:
- Filtered .list file in the same directory as input (name suffixed with -<version>.list)

Dependencies:
- MCP server
- -Delphel.mcp.allowed.configdir

Tags: mcp, list, models, filter

## field_calib_aggregate.py

Aggregate FIELD_CALIBRATION.corr-xml into CSV with per-sensor angles and noise metrics.

Path: `scripts/field_calib_aggregate.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/field_calib_aggregate.py /media/elphel/btrfs-data/lwir16-proc/NC/models/1763232117-1763234145 -o /home/elphel/CODEX/tmp/field_calib_1763232117-1763234145.csv
```

Inputs:
- Models root directory containing *-FIELD_CALIBRATION.corr-xml

Outputs:
- CSV file with per-sensor azimuth/tilt/roll columns and stats

Tags: csv, models, aggregation, plot

## rag_index.py

Build a local RAG index from attic/CODEX/rag_sources using fastembed + hnswlib.

Path: `scripts/rag_index.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_index.py --source /home/elphel/git/imagej-elphel/attic/CODEX/rag_sources --out /home/elphel/git/imagej-elphel/attic/CODEX/rag_index
```

Inputs:
- rag_sources root directory
- embedding model name (default: BAAI/bge-base-en-v1.5)

Outputs:
- index.bin
- meta.jsonl
- config.json

Dependencies:
- fastembed
- hnswlib
- numpy

Tags: rag, index, embedding

## rag_index.sh

Wrapper to run rag_index.py using the RAG venv.

Path: `scripts/rag_index.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_index.sh --source /home/elphel/git/imagej-elphel/attic/CODEX/rag_sources --out /home/elphel/git/imagej-elphel/attic/CODEX/rag_index
```

Inputs:
- same args as rag_index.py

Outputs:
- index.bin
- meta.jsonl
- config.json

Dependencies:
- rag_index.py
- rag venv

Tags: rag, index, wrapper

## rag_query.py

Query a local RAG index built by rag_index.py.

Path: `scripts/rag_query.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_query.py "Explain differential rectification"
```

Inputs:
- query string
- index directory (default: attic/CODEX/rag_index)

Outputs:
- Top-k matching chunks with file paths and snippets

Dependencies:
- fastembed
- hnswlib
- numpy

Tags: rag, query

## rag_query.sh

Wrapper to run rag_query.py using the RAG venv.

Path: `scripts/rag_query.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_query.sh "Explain differential rectification"
```

Inputs:
- query string
- index directory (default: attic/CODEX/rag_index)

Outputs:
- Top-k matching chunks with file paths and snippets

Dependencies:
- rag_query.py
- rag venv

Tags: rag, query, wrapper
