# Project scripts

This file is generated from `scripts/catalog.json`.

## How to register a new script

1) Add an entry in `scripts/catalog.json` under `scripts`.
2) Run:

```bash
/home/elphel/git/imagej-elphel/scripts/catalog_to_md.py
```

---

## Docs

### mcp-http-howto.md

HTTP MCP endpoints and usage notes for controlling imagej-elphel via MCP.

Path: `scripts/mcp-http-howto.md`

### email_send.py

Send SMTP email via mail.elphel.com using env vars for credentials.

Path: `scripts/email_send.py`

### email_fetch.py

Fetch email via IMAP (mail.elphel.com) and save messages to files.

Path: `scripts/email_fetch.py`

---

## mcp_filter_list_by_model_version.py

Filter a .list file to keep only sequences with an existing model version subdir.

Path: `scripts/mcp_filter_list_by_model_version.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/mcp_filter_list_by_model_version.py /media/elphel/btrfs-data/lwir16-proc/NC/lists/nc_site.list v89
```

Inputs:
- MCP server (http://127.0.0.1:48888)
- list file path (required)
- model version (from MCP dialog or CLI argument)

Outputs:
- Filtered .list file in the same directory as input (name suffixed with -<version>.list)

Dependencies:
- MCP server
- -Delphel.mcp.allowed.configdir

Tags: mcp, list, models, filter

## field_calib_aggregate.py

Aggregate FIELD_CALIBRATION.corr-xml into CSV with per-sensor angles and noise metrics.

Path: `scripts/field_calib_aggregate.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/field_calib_aggregate.py /media/elphel/btrfs-data/lwir16-proc/NC/models/1763232117-1763234145 -o /home/elphel/CODEX/tmp/field_calib_1763232117-1763234145.csv
```

Inputs:
- Models root directory containing *-FIELD_CALIBRATION.corr-xml

Outputs:
- CSV file with per-sensor azimuth/tilt/roll columns and stats

Tags: csv, models, aggregation, plot
