package com.elphel.imagej.correction;

import java.io.File;

import javax.swing.filechooser.FileFilter;

public class MultipleExtensionsFileFilter extends FileFilter {
	protected String[] patterns;
	protected String description = "JP4 files";

	public MultipleExtensionsFileFilter(String[] patterns, String description) {
		this.description = description;
		this.patterns = patterns.clone();
	}

	public MultipleExtensionsFileFilter(String[] patterns) {
		this.patterns = patterns.clone();
	}

	@Override
	public boolean accept(File file) {
		int i;
		String name = file.getName();
		if (file.isDirectory())
			return true;
		for (i = 0; i < patterns.length; i++) {
			if (name.toLowerCase().endsWith(patterns[i].toLowerCase()))
				return true;
		}
		return false;
	}

	@Override
	public String getDescription() {
		return description;
	}
}

