package com.elphel.imagej.orthomosaic;

import java.util.Arrays;

public class ItemPatternMatch {
//	public String pattern_path;
	public double [] sub_matches; // array of sub-pattern match qualities. [0] - is usually combo, [1] - full pattern, [2+] - obscured
	public int       best_sub = -1; // best subpattern
	public GroundObjectPattern groundObjectPattern;
	public ItemPatternMatch(GroundObjectPattern groundObjectPattern) {
		this.groundObjectPattern = groundObjectPattern;
	}
	public void setMatches(double [] matches) {
		sub_matches = matches;
	}
	
	public void setMatch(int indx, double match_value) { // not used
		if (sub_matches == null) {
			sub_matches = new double [indx+1];
			Arrays.fill(sub_matches, Double.NaN);
		} else if (sub_matches.length <= indx) {
			double [] old_matches = sub_matches;
			sub_matches = new double [indx+1];
			Arrays.fill(sub_matches, Double.NaN);
			System.arraycopy(old_matches, 0, sub_matches, 0, old_matches.length);
		}
		sub_matches[indx] = match_value;
	}

	public void setBestSub(int sub) {
		best_sub = sub;
	}
	
	public int getBestSub() { // 1 - full, > 1 - partial
		return best_sub;
	}
	
	public double getMatch(int indx) {
		if ((sub_matches == null) || (sub_matches.length <= indx)) {
			return Double.NaN;	
		}
		return sub_matches[indx];
	}
	/**
	 * Return actual largest value of full and all half patterns, regardless of best_sub which can point
	 * to full pattern even if the correlation value is larger for partial 
	 * @return
	 */
	public double getBestMatchValue() { //
		if (sub_matches == null) {
			return Double.NaN;
		}
		double best = 0;
		for (int i = 1; i < sub_matches.length; i++) {
			if (sub_matches[i] > best) {
				best = sub_matches[i];
			}
		}
		return best;
	}
	
	
	
	public double [] getMatches() {
		return sub_matches;
	}
	public GroundObjectPattern getGroundObjectPattern() {
		return groundObjectPattern;
	}
}


