package com.elphel.imagej.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class McpDialogSession {
    private final String id;
    private final String title;
    private final List<McpDialogField> fields;
    private final Map<String, String> valuesByLabel;

    public McpDialogSession(String title, List<McpDialogField> fields) {
        this.id = UUID.randomUUID().toString();
        this.title = title;
        this.fields = new ArrayList<McpDialogField>(fields);
        this.valuesByLabel = new HashMap<String, String>();
    }

    public String getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public List<McpDialogField> getFields() {
        return Collections.unmodifiableList(fields);
    }

    public void setValue(String label, String value) {
        if (label == null) {
            return;
        }
        valuesByLabel.put(label, value);
    }

    public String getValue(String label) {
        if (label == null) {
            return null;
        }
        return valuesByLabel.get(label);
    }
}
