package com.elphel.imagej.mcp;

import java.util.concurrent.atomic.AtomicReference;

public class McpDialogRegistry {
    private static final AtomicReference<McpDialogSession> CURRENT = new AtomicReference<McpDialogSession>(null);

    private McpDialogRegistry() {
    }

    public static boolean setCurrent(McpDialogSession session) {
        if (session == null) {
            CURRENT.set(null);
            return true;
        }
        McpDialogSession existing = CURRENT.get();
        if (existing != null) {
            return false;
        }
        CURRENT.set(session);
        return true;
    }

    public static McpDialogSession getCurrent() {
        return CURRENT.get();
    }

    public static boolean setValue(String label, String value) {
        McpDialogSession session = CURRENT.get();
        if (session == null) {
            return false;
        }
        session.setValue(label, value);
        return true;
    }

    public static boolean setValueForId(String id, String label, String value) {
        McpDialogSession session = CURRENT.get();
        if (session == null || id == null || !id.equals(session.getId())) {
            return false;
        }
        session.setValue(label, value);
        return true;
    }

    public static boolean submitCurrent(boolean ok) {
        McpDialogSession session = CURRENT.get();
        if (session == null) {
            return false;
        }
        session.submit(ok);
        CURRENT.set(null);
        return true;
    }

    public static boolean submitForId(String id, boolean ok) {
        McpDialogSession session = CURRENT.get();
        if (session == null || id == null || !id.equals(session.getId())) {
            return false;
        }
        session.submit(ok);
        CURRENT.set(null);
        return true;
    }
}
