#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"
CLIENT="${REPO_ROOT}/scripts/eyesis_host_daemon.py"
QUEUE_DIR="${EYESIS_HOST_QUEUE_DIR:-${REPO_ROOT}/attic/session-logs/eyesis-host-daemon}"
WAIT_SEC="${EYESIS_HOST_WAIT_SEC:-120}"
TIMEOUT_SEC="${EYESIS_HOST_TIMEOUT_SEC:-300}"

usage() {
  cat <<'USAGE'
Usage:
  scripts/eyesis_host_submit.sh ctl <args...>
  scripts/eyesis_host_submit.sh mcp <args...>

Examples:
  scripts/eyesis_host_submit.sh ctl status
  scripts/eyesis_host_submit.sh ctl start --configdir /media/elphel/btrfs-data/lwir16-proc/NC/config --wait-sec 120
  scripts/eyesis_host_submit.sh mcp button --label "Restore"

Environment:
  EYESIS_HOST_QUEUE_DIR, EYESIS_HOST_WAIT_SEC, EYESIS_HOST_TIMEOUT_SEC
USAGE
}

[[ $# -ge 2 ]] || { usage; exit 2; }
action="$1"; shift
case "${action}" in
  ctl|mcp) ;;
  *) echo "action must be ctl or mcp" >&2; usage; exit 2 ;;
esac

exec "${CLIENT}" submit \
  --queue-dir "${QUEUE_DIR}" \
  --action "${action}" \
  --wait-sec "${WAIT_SEC}" \
  --timeout-sec "${TIMEOUT_SEC}" \
  -- "$@"
