# Eyesis Host Daemon HOWTO

This daemon avoids repeated Codex approval prompts by running host-side command execution in your desktop session.
Codex then submits requests through a file queue in the workspace.

## Why use it
- No per-command approval prompts after daemon is started.
- Works across machines with one-time startup.
- Keeps command scope restricted to existing wrappers:
  - `scripts/eyesis_mcp_ctl.sh`
  - `scripts/mcp_http.sh`

## Components
- `scripts/eyesis_host_daemon.py`:
  - `serve`: daemon loop
  - `submit`: enqueue a request and optionally wait for response
- `scripts/eyesis_host_daemon_ctl.sh`:
  - start/stop/restart/status/logs for daemon itself
- `scripts/eyesis_host_submit.sh`:
  - convenience wrapper around `submit`

## One-time start (per login)
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon_ctl.sh start
```

Check status:
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon_ctl.sh status
```

View daemon log:
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon_ctl.sh logs --lines 120
```

Real-time tails in a separate console:
```bash
tail -n 200 -F /home/elphel/git/imagej-elphel/attic/session-logs/eyesis_mcp.log
tail -n 100 -F /home/elphel/git/imagej-elphel/attic/session-logs/eyesis_host_daemon.log
```

Quick post-run summary and baseline compare:
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_run_report.py extract --snapshot-dir /tmp/eyesis-reports --auto-compare
# optional explicit compare using generated pointers:
/home/elphel/git/imagej-elphel/scripts/eyesis_run_report.py compare --base /tmp/eyesis-reports/run_previous.json --new /tmp/eyesis-reports/run_latest.json
```

## Request examples
Daemon-backed lifecycle request:
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_submit.sh ctl status
/home/elphel/git/imagej-elphel/scripts/eyesis_host_submit.sh ctl start --configdir /media/elphel/btrfs-data/lwir16-proc/NC/config --wait-sec 120
```

Daemon-backed MCP request:
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_submit.sh mcp status
/home/elphel/git/imagej-elphel/scripts/eyesis_host_submit.sh mcp button --label "Restore"
```

## Queue and logs
Default queue directory:
- `attic/session-logs/eyesis-host-daemon/`

Subdirectories:
- `requests/` incoming jobs
- `processing/` in-progress jobs
- `responses/` completed results
- `archive/` processed request files

Daemon log:
- `attic/session-logs/eyesis_host_daemon.log`

Eyesis console log (from lifecycle script):
- `attic/session-logs/eyesis_mcp.log`

## Stop daemon
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon_ctl.sh stop
```

Force stop if needed:
```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon_ctl.sh stop --force
```

## New computer setup
1. Copy/clone repo.
2. Build once (`mvn -DskipTests clean package`) from your normal user session.
3. Start daemon (`eyesis_host_daemon_ctl.sh start`).
4. Use `eyesis_host_submit.sh` for run control.
