# Project scripts

This file is generated from `scripts/catalog.json`.

## How to register a new script

1) Add an entry in `scripts/catalog.json` under `scripts`.
2) Run:

```bash
/home/elphel/git/imagej-elphel/scripts/catalog_to_md.py
```

---

## Docs

### mcp-http-howto.md

HTTP MCP endpoints and usage notes for controlling imagej-elphel via MCP.

Path: `scripts/mcp-http-howto.md`

### eyesis-host-daemon-howto.md

Host daemon workflow that removes repeated approval prompts by using a local file queue.

Path: `scripts/eyesis-host-daemon-howto.md`

### email_send.py

Send email via SSH+sendmail on community.elphel.com by default (set ELPHEL_SEND_MODE=smtp to force SMTP).

Path: `scripts/email_send.py`

### email_fetch.py

Fetch email via IMAP (mail.elphel.com) and save messages to files.

Path: `scripts/email_fetch.py`

---

## mcp_filter_list_by_model_version.py

Filter a .list file to keep only sequences with an existing model version subdir.

Path: `scripts/mcp_filter_list_by_model_version.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/mcp_filter_list_by_model_version.py /media/elphel/btrfs-data/lwir16-proc/NC/lists/nc_site.list v89
```

Inputs:
- MCP server (http://127.0.0.1:48888)
- list file path (required)
- model version (from MCP dialog or CLI argument)

Outputs:
- Filtered .list file in the same directory as input (name suffixed with -<version>.list)

Dependencies:
- MCP server
- -Delphel.mcp.allowed.configdir

Tags: mcp, list, models, filter

## field_calib_aggregate.py

Aggregate FIELD_CALIBRATION.corr-xml into CSV with per-sensor angles and noise metrics.

Path: `scripts/field_calib_aggregate.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/field_calib_aggregate.py /media/elphel/btrfs-data/lwir16-proc/NC/models/1763232117-1763234145 -o /home/elphel/CODEX/tmp/field_calib_1763232117-1763234145.csv
```

Inputs:
- Models root directory containing *-FIELD_CALIBRATION.corr-xml

Outputs:
- CSV file with per-sensor azimuth/tilt/roll columns and stats

Tags: csv, models, aggregation, plot

## rag_index.py

Build a local RAG index from attic/CODEX/rag_sources using fastembed + hnswlib.

Path: `scripts/rag_index.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_index.py --source /home/elphel/git/imagej-elphel/attic/CODEX/rag_sources --out /home/elphel/git/imagej-elphel/attic/CODEX/rag_index
```

Inputs:
- rag_sources root directory
- embedding model name (default: BAAI/bge-base-en-v1.5)

Outputs:
- index.bin
- meta.jsonl
- config.json

Dependencies:
- fastembed
- hnswlib
- numpy

Tags: rag, index, embedding

## rag_index.sh

Wrapper to run rag_index.py using the RAG venv.

Path: `scripts/rag_index.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_index.sh --source /home/elphel/git/imagej-elphel/attic/CODEX/rag_sources --out /home/elphel/git/imagej-elphel/attic/CODEX/rag_index
```

Inputs:
- same args as rag_index.py

Outputs:
- index.bin
- meta.jsonl
- config.json

Dependencies:
- rag_index.py
- rag venv

Tags: rag, index, wrapper

## rag_query.py

Query a local RAG index built by rag_index.py.

Path: `scripts/rag_query.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_query.py "Explain differential rectification"
```

Inputs:
- query string
- index directory (default: attic/CODEX/rag_index)

Outputs:
- Top-k matching chunks with file paths and snippets

Dependencies:
- fastembed
- hnswlib
- numpy

Tags: rag, query

## rag_query.sh

Wrapper to run rag_query.py using the RAG venv.

Path: `scripts/rag_query.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/rag_query.sh "Explain differential rectification"
```

Inputs:
- query string
- index directory (default: attic/CODEX/rag_index)

Outputs:
- Top-k matching chunks with file paths and snippets

Dependencies:
- rag_query.py
- rag venv

Tags: rag, query, wrapper

## eyesis_mcp_ctl.sh

Lifecycle controller for Eyesis_Correction in MCP mode (start/stop/restart/status/logs/wait).

Path: `scripts/eyesis_mcp_ctl.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_mcp_ctl.sh start --configdir /media/elphel/btrfs-data/lwir16-proc/NC/config --rebuild
```

Inputs:
- command: start|stop|restart|status|logs|wait
- optional flags: --configdir/--config/--port/--rebuild/--log
- environment overrides: EYESIS_MCP_*

Outputs:
- Background JVM process managed by pid file
- MCP readiness checks and status output
- Log file at attic/session-logs/eyesis_mcp.log by default

Dependencies:
- mvn
- curl

Tags: mcp, lifecycle, launcher, automation

## mcp_http.sh

Thin MCP HTTP wrapper for status/dialog/button/value/submit/interrupt operations.

Path: `scripts/mcp_http.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/mcp_http.sh button --label "Restore"
```

Inputs:
- subcommand: status|dialog|button|set|submit|interrupt|confirm-stop
- subcommand flags like --label/--value/--id/--ok
- optional --base and --timeout (or EYESIS_MCP_BASE_URL/EYESIS_MCP_TIMEOUT_SEC)

Outputs:
- Raw JSON response from MCP HTTP endpoint

Dependencies:
- curl

Tags: mcp, http, automation, wrapper

## eyesis_host_daemon.py

Host-side queue daemon that executes whitelisted lifecycle/MCP wrapper commands in desktop session context.

Path: `scripts/eyesis_host_daemon.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon.py submit --action ctl -- status
```

Inputs:
- serve mode with queue dir and poll interval
- submit mode: action ctl|mcp and args after --
- read mode: request id

Outputs:
- JSON response files in queue responses/
- stdout/stderr passthrough for submit --wait-sec

Dependencies:
- python3

Tags: daemon, queue, automation, mcp, lifecycle

## eyesis_host_daemon_ctl.sh

Start/stop/status/logs helper for eyesis_host_daemon.py.

Path: `scripts/eyesis_host_daemon_ctl.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_daemon_ctl.sh start
```

Inputs:
- command: start|stop|restart|status|logs
- optional flags: --queue-dir/--log/--poll-ms/--force

Outputs:
- Background daemon process and PID file
- Daemon status and log streaming

Dependencies:
- python3

Tags: daemon, control, automation

## eyesis_host_submit.sh

Convenience wrapper to submit daemon requests for ctl/mcp actions.

Path: `scripts/eyesis_host_submit.sh`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_host_submit.sh mcp status
```

Inputs:
- action: ctl or mcp
- subcommand arguments for selected action

Outputs:
- Command output from daemon response

Dependencies:
- python3
- eyesis_host_daemon.py

Tags: daemon, client, automation, mcp, lifecycle

## eyesis_run_report.py

Extract latest completed Eyesis run summary from eyesis_mcp.log and compare report JSONs.

Path: `scripts/eyesis_run_report.py`

Example:

```bash
/home/elphel/git/imagej-elphel/scripts/eyesis_run_report.py extract --snapshot-dir /tmp/eyesis-reports --auto-compare
```

Inputs:
- extract: --log path (default attic/session-logs/eyesis_mcp.log)
- extract: optional --json output, --snapshot-dir DIR, --auto-compare, --show-outputs N
- compare: --base report.json --new report.json

Outputs:
- Console summary for latest completed run
- Optional JSON report and/or timestamped snapshots for baseline tracking
- CSV-like metric delta table for report comparisons

Dependencies:
- python3

Tags: log, report, lma, comparison, automation
