# Stage 1 plan: command-line build in Docker

Goal: produce a reliable CLI build path on this machine, inside Docker, matching current behavior as closely as practical.

## Success criteria

1. `setup.py` runs successfully in containerized workspace.
2. `bitbake u-boot device-tree linux-xlnx core-image-elphel393` completes.
3. Output artifacts are produced in expected deploy path.
4. No host reboot required for normal build cycles.

## Baseline source of truth

- Reference environment:
  - Host: `elphel@192.168.0.107`
  - Path: `/home/elphel/git/elphel393`
  - Branch: `warrior`
- Setup/update entrypoint:
  - `./setup.py`
- Mode:
  - developer mode only (SSH remotes)

## Work steps

1. Inventory reference environment (`scripts/audit_107.sh`).
2. Build Docker image (`docker/Dockerfile`).
3. Create workspace volume and clone `elphel393` (`warrior`) into `workspace/`.
   - force SSH: `git@git.elphel.com:Elphel/elphel393.git`
4. Run `setup.py` inside container.
5. Build incremental targets first (`u-boot`, `device-tree`, `linux-xlnx`), then full image.
6. Capture logs and deltas vs `.107`.

## Known constraints

- Yocto warrior and dependencies are sensitive to host toolchain drift.
- Some components still expect Python 2 era compatibility.
- Kernel/FPGA workflows and Eclipse-specific conventions must remain possible later.

## Deferred to later stages

- Eclipse runtime integration and launch config parity.
- VDT plugin/toolchain specifics.
- Deployment UX and automation hardening.

## Deferred warning cleanup TODO

- `libogg-1.3.3` patch fuzz warning (`[patch-fuzz]`) is currently accepted for migration parity.
- After Stage 1 stabilization, refresh affected patch context with `devtool` and review resulting patch updates.
