#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"
WORKSPACE="${REPO_ROOT}/workspace"

if [[ ! -x "${WORKSPACE}/setup.py" ]]; then
  echo "ERROR: ${WORKSPACE}/setup.py not found or not executable." >&2
  echo "Run ./scripts/bootstrap_workspace.sh first." >&2
  exit 1
fi

if [[ $# -eq 0 ]]; then
  TARGETS=(u-boot device-tree linux-xlnx core-image-elphel393)
else
  TARGETS=("$@")
fi

TARGETS_STR="${TARGETS[*]}"

"${SCRIPT_DIR}/run_docker.sh" bash -lc "
set -e
cd /work/elphel393
./setup.py
cd poky
set +u
. ./oe-init-build-env build
set -u
bitbake ${TARGETS_STR}
"
