#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"
WORKSPACE="${REPO_ROOT}/workspace"
REF="${REPO_ROOT}/docs/reference/107/local.conf"
DST="${WORKSPACE}/poky/build/conf/local.conf"

if [[ ! -f "${REF}" ]]; then
  echo "ERROR: reference local.conf not found: ${REF}" >&2
  exit 1
fi

if [[ ! -f "${DST}" ]]; then
  echo "ERROR: workspace local.conf not found: ${DST}" >&2
  exit 1
fi

echo "Reference: ${REF}"
echo "Workspace: ${DST}"
echo
sha256sum "${REF}" "${DST}"
echo
if diff -u "${REF}" "${DST}"; then
  echo "local.conf matches .107 reference"
else
  echo "local.conf differs from .107 reference"
fi
