#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"
WORKSPACE="${WORKSPACE:-${REPO_ROOT}/workspace}"

if [[ ! -d "${WORKSPACE}" ]]; then
  echo "ERROR: workspace not found: ${WORKSPACE}" >&2
  exit 1
fi

fail=0

while IFS= read -r gitdir; do
  repo="${gitdir%/.git}"
  url="$(git -C "${repo}" remote get-url origin 2>/dev/null || true)"
  if [[ -z "${url}" ]]; then
    continue
  fi
  if [[ "${url}" == *"git.elphel.com"* ]]; then
    if [[ "${url}" != git@git.elphel.com:* ]]; then
      echo "NON-SSH remote: ${repo} -> ${url}"
      fail=1
    fi
  fi
done < <(find "${WORKSPACE}" -type d -name .git)

if [[ "${fail}" -ne 0 ]]; then
  echo "FAIL: found non-SSH remotes for git.elphel.com repos" >&2
  exit 2
fi

echo "OK: all git.elphel.com remotes under ${WORKSPACE} use SSH."
