#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"
LOG_DIR="${REPO_ROOT}/logs"
mkdir -p "${LOG_DIR}"

TARGET="${TARGET:-elphel@192.168.0.107}"
REMOTE_REPO="${REMOTE_REPO:-/home/elphel/git/elphel393}"
TS="$(date +%Y%m%d_%H%M%S)"
OUT="${LOG_DIR}/audit_107_${TS}.log"

{
  echo "=== AUDIT START ${TS} ==="
  echo "TARGET=${TARGET}"
  echo "REMOTE_REPO=${REMOTE_REPO}"
  echo

  ssh "${TARGET}" "set -euo pipefail; \
    echo '=== HOST ==='; hostname; uname -a; \
    echo; \
    echo '=== REPO ==='; cd '${REMOTE_REPO}'; pwd; \
    git rev-parse --abbrev-ref HEAD; \
    git rev-parse HEAD; \
    git remote -v; \
    echo; \
    echo '=== ROOT CONTENTS ==='; ls -la | sed -n '1,160p'; \
    echo; \
    echo '=== README (top) ==='; sed -n '1,220p' README.md; \
    echo; \
    echo '=== setup.py (top) ==='; sed -n '1,320p' setup.py; \
    echo; \
    echo '=== projects.json (top) ==='; sed -n '1,320p' projects.json; \
    echo; \
    echo '=== TOOLCHAIN BITS ==='; \
    command -v bitbake || true; \
    command -v python || true; python --version 2>&1 || true; \
    command -v python3 || true; python3 --version 2>&1 || true; \
    command -v git || true; git --version || true; \
    command -v docker || true; docker --version 2>&1 || true"
} | tee "${OUT}"

echo "Saved audit log: ${OUT}"
