#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"

if command -v docker >/dev/null 2>&1; then
  :
else
  echo "ERROR: docker is not installed" >&2
  exit 1
fi

if docker compose version >/dev/null 2>&1; then
  COMPOSE=(docker compose)
elif command -v docker-compose >/dev/null 2>&1; then
  COMPOSE=(docker-compose)
else
  echo "ERROR: docker compose is not available" >&2
  exit 1
fi

mkdir -p "${REPO_ROOT}/workspace" "${REPO_ROOT}/cache/downloads" "${REPO_ROOT}/cache/sstate-cache" "${REPO_ROOT}/cache/ccache"

export USER_ID="${USER_ID:-$(id -u)}"
export GROUP_ID="${GROUP_ID:-$(id -g)}"
export USER_NAME="${USER_NAME:-$(id -un)}"

if [[ $# -eq 0 ]]; then
  CMD=(bash)
else
  CMD=("$@")
fi

"${COMPOSE[@]}" -f "${REPO_ROOT}/docker/docker-compose.yml" run --rm warrior "${CMD[@]}"
