# Project details (working context)

This file captures hardware/system context that affects migration decisions.

## System role

`elphel393` runs on Elphel camera hardware (Zynq ARM+FPGA) with custom Linux/Yocto stack and many custom drivers and FPGA-linked interfaces.

## Sensor and host topology

Active camera subsystem hosts:

- `192.168.0.41` controls LWIR channels `0..3` (channel 0 at top, then clockwise viewed in camera direction)
- `192.168.0.42` controls LWIR channels `4..7`
- `192.168.0.43` controls LWIR channels `8..11`
- `192.168.0.44` controls LWIR channels `12..15`
- `192.168.0.45` controls RGB channels:
  - `16` right/top
  - `17` right/bottom
  - `18` left/bottom
  - `19` left/top
- `192.168.0.46` controls IMU/GNSS subsystem (InertialSense-based path)

Each host has local SATA SSD storage. Filenames are synchronized via shared master timestamp.

## Synchronization

In addition to Ethernet communication, subsystem hosts are tied by a dedicated coax sync link:

- Trigger edge + 64-bit master timestamp
- Decoded by FPGA
- Timing accuracy around 1 microsecond

## Software architecture constraints

- Kernel is heavily customized (not only `drivers/elphel`).
- Sparse-tree method is used for modified kernel files.
- Eclipse workflow follows symlinks into git-controlled sparse sources.
- Header handling for CDT is augmented by custom scripts that inspect Yocto build include usage.
- Build/deploy workflow is already script-integrated with Eclipse and SCP.

## Migration intent

- Primary target: command-line reproducible Docker build on this workstation.
- Secondary target (later): preserve compatibility for Eclipse + VDT workflow.
- Keep old workstation (`192.168.0.107`) as reference while migrating.
