# elphel393-docker

Docker-first migration workspace for running and maintaining `elphel393` (Yocto warrior) on a newer host while keeping compatibility with existing workflow.

## Current goal

Stage 1 only:

1. Build from command line in Docker on this machine.
2. Keep behavior close to the current known-good setup on `elphel@192.168.0.107:/home/elphel/git/elphel393`.
3. Defer Eclipse/VDT integration details to later, but keep architecture decisions compatible with that future work.

## Mode policy

- This repository targets **developer mode only**.
- For git access, use **SSH only** (`git@git.elphel.com:...`).
- HTTPS/user mode is intentionally out of scope here.

## Scope

In scope now:

- Docker image/runtime for Yocto warrior builds.
- Repeatable host-to-container workflow.
- Documentation and checklists for migration.
- Utility scripts used during hardware work (including Konsole multi-SSH launcher).

Out of scope now:

- Full Eclipse integration.
- VDT plugin integration.
- Runtime deployment redesign on camera hosts.

## Repository layout

- `docker/` container build/runtime files.
- `scripts/` helper scripts.
- `docs/` migration notes and plans.

## Quick start

1. Build and enter the container:

```bash
./scripts/run_docker.sh
```

2. Inside container, use normal `elphel393` flow (after workspace is prepared):

```bash
./setup.py
cd poky
. ./oe-init-build-env
bitbake u-boot device-tree linux-xlnx core-image-elphel393
```

Bootstrap workspace in developer mode:

```bash
./scripts/bootstrap_workspace.sh
./scripts/verify_ssh_remotes.sh
```

Use known-good `.107` local.conf by default during stage-1 builds:

```bash
./scripts/build_stage1.sh
./scripts/compare_localconf_with_107.sh
```

## References

- Main upstream repository: `git@git.elphel.com:Elphel/elphel393.git` (`warrior` branch)
- Development wiki: https://wiki.elphel.com/wiki/Development_for_10393
- Poky manual page used by project: https://wiki.elphel.com/wiki/Poky_manual

## Notes

- The canonical setup/update logic for subprojects remains `setup.py` from project root.
- Migration should preserve sparse-kernel workflow and future Eclipse/VDT compatibility.
