#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/.." && pwd)"
WORKSPACE="${REPO_ROOT}/workspace"
REF_DIR="${REPO_ROOT}/docs/reference/107"
USE_107_LOCALCONF="${USE_107_LOCALCONF:-1}"

copy_localconf_107() {
  local src="${REF_DIR}/local.conf"
  local dst="${WORKSPACE}/poky/build/conf/local.conf"

  if [[ ! -f "${src}" ]]; then
    echo "WARN: ${src} missing, skipping .107 local.conf override" >&2
    return 0
  fi
  if [[ ! -f "${dst}" ]]; then
    echo "WARN: ${dst} missing, cannot apply .107 local.conf yet" >&2
    return 0
  fi

  cp -f "${dst}" "${dst}.before_107" || true
  cp -f "${src}" "${dst}"
  echo "Applied .107 local.conf -> ${dst}"
}

if [[ ! -x "${WORKSPACE}/setup.py" ]]; then
  echo "ERROR: ${WORKSPACE}/setup.py not found or not executable." >&2
  echo "Run ./scripts/bootstrap_workspace.sh first." >&2
  exit 1
fi

if [[ $# -eq 0 ]]; then
  TARGETS=(u-boot device-tree linux-xlnx core-image-elphel393)
else
  TARGETS=("$@")
fi

TARGETS_STR="${TARGETS[*]}"

# Step 1: setup and generate config in workspace.
"${SCRIPT_DIR}/run_docker.sh" bash -lc "
set -e
cd /work/elphel393
./setup.py
"

# Step 2: enforce known-good local.conf from .107 when requested.
if [[ "${USE_107_LOCALCONF}" == "1" ]]; then
  copy_localconf_107
fi

# Step 3: build targets.
"${SCRIPT_DIR}/run_docker.sh" bash -lc "
set -e
cd /work/elphel393/poky
set +u
. ./oe-init-build-env build
set -u
bitbake ${TARGETS_STR}
"
