# Migration trouble assessment (initial)

This is an initial risk view before running migration actions.

## Estimated trouble by area

1. Yocto warrior dependency compatibility on modern host: **High**
2. Docker user/permission/ownership behavior with existing git trees: **High**
3. Build cache performance (`downloads`, `sstate-cache`) and disk usage: **Medium**
4. Reproducibility of `setup.py` multi-repo state inside container: **Medium**
5. Eclipse/VDT future compatibility (not implemented in Stage 1): **Medium-High**

## Why this is manageable

- Existing `.107` installation is available as a known-good reference.
- `setup.py` already centralizes multi-repo orchestration.
- Stage 1 is limited to CLI build parity, reducing variables.
- User/HTTPS mode is excluded; this repo standardizes on developer/SSH mode only.

## Main failure modes to watch

1. Missing/changed package versions in container.
2. Broken SSH credentials inside container for private repo access.
3. UID/GID mismatch causing file ownership or git safety issues.
4. Non-deterministic branch/hash selection in project dependencies.
5. Build scripts assuming non-container host paths.

## Mitigation strategy

1. Keep container user mapped to host UID/GID.
2. Persist `downloads` and `sstate-cache` across runs.
3. Keep migration logs and exact command history in this repo.
4. Validate each step against `.107` before moving forward.
5. Defer IDE concerns until CLI build is stable.
