# LWIR-16 Operation Manual (Working Draft)

Converted from:
- `/home/elphel/git/imagej-elphel/attic/InertialSense/operation_manual.txt`

Companion reference:
- `/home/elphel/git/imagej-elphel/attic/InertialSense/InertialSenseDocs_large_datasheet.pdf`

Status:
- This is a migrated working draft (not yet fully cleaned).
- Keep command examples practical and update in place as procedures are verified.

## System Topology

Camera system modules (16 LWIR + 4 EO sensors, plus IMU/GNSS logger):

- `192.168.0.41` - LWIR sensors `0..3` (channel 0 at 12 o'clock, then clockwise)
- `192.168.0.42` - LWIR sensors `4..7`
- `192.168.0.43` - LWIR sensors `8..11`
- `192.168.0.44` - LWIR sensors `12..15`
- `192.168.0.45` - EO channels `16..19` (clockwise from top-right)
- `192.168.0.46` - IMU/GNSS logger and multicam control host

Notes:
- `.41` is sync master (white audio connector); others are sync slaves (black cables).
- One camera core on `.42` may show corrected corruption; this is expected in existing setup.

## A) SSH To Cameras

### 1) Legacy SSH compatibility (host side)

If needed on Linux host, add to `~/.ssh/config`:

```sshconfig
# Legacy changes
KexAlgorithms +diffie-hellman-group1-sha1
Ciphers +aes128-cbc
```

### 2) Passwordless access

```bash
ssh-copy-id root@192.168.0.41
ssh-copy-id root@192.168.0.42
ssh-copy-id root@192.168.0.43
ssh-copy-id root@192.168.0.44
ssh-copy-id root@192.168.0.45
ssh-copy-id root@192.168.0.46
```

### 3) Open 2x3 SSH console layout

From this migration repo:

```bash
/home/elphel/git/imagej-elphel/attic/elphel393-docker/scripts/konsole_ssh_2x3.sh
```

Or with immediate remote `dmesg`:

```bash
/home/elphel/git/imagej-elphel/attic/elphel393-docker/scripts/konsole_ssh_2x3.sh --dmesg
```

## B) Running Cameras In Recording Mode

1. Power cameras and wait about 1 minute before opening UI pages.
2. Open multicam page:

```text
http://192.168.0.46/multicam/index3.html
```

3. Optional tuning in logger host:

```bash
nano /etc/elphel393/lwir16.ini
```

Suggested values from legacy notes:

```ini
lwir_fps  = 55.0
pre_delay = 1.0
ffc_period = 300.0
```

4. Open sequencer UI:

```text
http://192.168.0.46/lwir16/
```

5. Start/stop recording with the large round button in Eyesis controls.

## C) IMU/GNSS Quick `cltool` Commands

These are the two command lines currently used for quick IMU stream checks:

```bash
cltool -c /dev/ttyUSB0 -baud=921600 -stats -did DID_INS_1 DID_GPS1_POS DID_GPS2_POS  DID_GPS1_UBX_POS DID_STROBE_IN_TIME DID_PIMU
cltool -c /dev/ttyUSB0 -baud=921600  -did DID_INS_1 DID_GPS1_POS DID_GPS2_POS  DID_GPS1_UBX_POS DID_STROBE_IN_TIME DID_PIMU
```

Operational notes:
- `cltool` updates output in place in terminal; behavior is not line-buffered like standard logs.
- Normal stop is `Ctrl-C`.
- For persistent stream setup across reboot, check `cltool` options `-persistent` and `-flashCfg` (see investigation notes in this repo).

## D) Erasing SSD Data On Camera Hosts

LWIR/EO hosts (`.41`..`.45`) local command:

```bash
rm /mnt/sda1/*.disk
```

From host for all LWIR/EO cameras:

```bash
ssh root@192.168.0.41 "rm /mnt/sda1/*.disk"; \
ssh root@192.168.0.42 "rm /mnt/sda1/*.disk"; \
ssh root@192.168.0.43 "rm /mnt/sda1/*.disk"; \
ssh root@192.168.0.44 "rm /mnt/sda1/*.disk"; \
ssh root@192.168.0.45 "rm /mnt/sda1/*.disk"
```

Logger host `.46` usually uses much less space; erase selectively if needed.

## E) Example Download / Extraction Commands (Legacy Notes)

```bash
time /home/elphel/git/elphel-tools-x393/int_ssd_download.py -c root@192.168.0.41 -fs kyiv02_0000.disk -fe camogm.disk /home/elphel/lwir16-proc/kyiv02/footage/41
time /home/elphel/git/elphel-tools-x393/int_ssd_download.py -c root@192.168.0.42 -fs kyiv02_0000.disk -fe camogm.disk /home/elphel/lwir16-proc/kyiv02/footage/42
time /home/elphel/git/elphel-tools-x393/int_ssd_download.py -c root@192.168.0.43 -fs kyiv02_0000.disk -fe camogm.disk /home/elphel/lwir16-proc/kyiv02/footage/43
time /home/elphel/git/elphel-tools-x393/int_ssd_download.py -c root@192.168.0.44 -fs kyiv02_0000.disk -fe camogm.disk /home/elphel/lwir16-proc/kyiv02/footage/44
time /home/elphel/git/elphel-tools-x393/int_ssd_download.py -c root@192.168.0.45 -fs kyiv02_0000.disk -fe camogm.disk /home/elphel/lwir16-proc/kyiv02/footage/45
```

```bash
time /home/elphel/git/elphel-tools-x393/extract_images_tiff.php path=//home/elphel/lwir16-proc/kyiv02/footage/41 dest_path=results chn_offs=0
time /home/elphel/git/elphel-tools-x393/extract_images_tiff.php path=//home/elphel/lwir16-proc/kyiv02/footage/42 dest_path=results chn_offs=4
time /home/elphel/git/elphel-tools-x393/extract_images_tiff.php path=//home/elphel/lwir16-proc/kyiv02/footage/43 dest_path=results chn_offs=8
time /home/elphel/git/elphel-tools-x393/extract_images_tiff.php path=//home/elphel/lwir16-proc/kyiv02/footage/44 dest_path=results chn_offs=12
time /home/elphel/git/elphel-tools-x393/extract_images_tiff.php path=//home/elphel/lwir16-proc/kyiv02/footage/45 dest_path=results chn_offs=16
```

## TODO (Next Pass)

- Add exact `cltool` persistent-configuration workflow that survives reboot.
- Add IMU logger (`/dev/imu_ctl`, `/etc/elphel393/imu_logger.xml`) relationship to `cltool`.
- Cross-reference FPGA logger `dmesg` messages from host `.46`.
- Move cleaned procedure to project wiki once stable.
