# IMU `cltool` Source Notes (Yocto Warrior Build)

This note captures where `cltool` comes from in the current `elphel393` Yocto build and what it supports for INS datasets and persistence.

## Where `cltool` is built from

Yocto recipe:
- `meta/meta-elphel393/recipes-core/cltool/cltool_1.0.bb`

Key details:
- Source repo: `git://github.com/inertialsense/inertial-sense-sdk.git;protocol=https`
- Fixed `SRCREV`: `0757da6f2e0fb3c430f6e6f5af0d5f3411fdb1b1`
- Installed binary: `${bindir}/cltool`

## Local source tree used during build

Built source location in current workspace:
- `poky/build/tmp/work/cortexa9t2hf-neon-poky-linux-gnueabi/cltool/1.0-r0/git`

## DID support relevant to current issue

`DID_INS_2` is defined and handled in this SDK:
- `src/data_sets.h` defines:
  - `DID_INS_1 = 4`
  - `DID_INS_2 = 5`
- `src/ISDataMappings.cpp` includes names for both `DID_INS_1` and `DID_INS_2`.
- `src/cltool.cpp` help text lists `DID_INS_2` as common.

`-did` parsing supports either numeric DID (`5`) or name (`DID_INS_2`):
- `src/cltool.cpp`, function `read_did_argument(...)`.

## Persistence and startup streaming behavior

`cltool` options related to persistent behavior:
- `-persistent`: saves currently configured streams to flash
  - Implemented by sending `SYS_CMD_SAVE_PERSISTENT_MESSAGES`
  - See `src/cltool_main.cpp`
- `-flashCfg` and `-flashCfg=key=value|...`
  - Reads/updates flash config keys
  - See `src/cltool.cpp`, `cltool_updateFlashCfg(...)`

Relevant preset:
- `-presetPPD` maps to `RMC_PRESET_PPD_GROUND_VEHICLE`
- `RMC_PRESET_PPD_BITS` includes `RMC_BITS_INS2` (i.e., INS2 is part of preset stream mask)
- See `src/data_sets.h` (`RMC_PRESET_*` and `RMC_BITS_*` definitions).

## Practical implication for current debugging

The SDK used by Yocto build does support `DID_INS_2` in `cltool`.
If only `DID_INS_1` appears in runtime behavior, the root cause is likely one of:
- device-side stream config not enabling INS2,
- persistent stream config overwritten or not saved,
- transport/logging path selecting a subset of DIDs.

## Suggested command probes on target (`.46`)

List available DIDs and verify parser names:

```bash
cltool -c /dev/ttyUSB0 -baud=921600 -dids
```

Force stream INS2 explicitly:

```bash
cltool -c /dev/ttyUSB0 -baud=921600 -did DID_INS_2 DID_INS_1 DID_GPS1_POS
```

Try saving current stream setup:

```bash
cltool -c /dev/ttyUSB0 -baud=921600 -did DID_INS_2 DID_GPS1_POS -persistent
```

Inspect flash config keys:

```bash
cltool -c /dev/ttyUSB0 -baud=921600 -flashCfg
```

## Notes imported from legacy host `.107`

Reference file:
- `/home/elphel/git/imagej-elphel/attic/InertialSense/cltool_references.txt`

Observed/confirmed there:
- `cltool -c ttyACM0 -dids` lists both:
  - `DID_INS_1` (4)
  - `DID_INS_2` (5)
- `-flashCfg` is the valid option name.
- `-flashConfig` is not recognized by this `cltool` build (important typo trap).
- `cltool -c /dev/ttyACM0 -flashCfg` prints flash config including startup periods and IO config fields.

Example from notes (works):

```bash
cltool -c ttyACM0 -dids
cltool -c /dev/ttyACM0 -flashCfg
```

Known-bad example from notes (do not use):

```bash
cltool -c ttyACM0 -flashConfig=ser1BaudRate=115200
```

Expected error:

```text
Unrecognized command line option: -flashConfig=...
```

Hardware timing note captured in references:
- STROBE output uses `DID_FLASH_CONFIG.ioConfig` bit `IO_CONFIG_G9_STROBE_OUTPUT_NAV` (`0x00000020`) to indicate IMU preintegration/nav update timing on G9.
