#!/usr/bin/php
<?php
/*!*******************************************************************************
*! FILE NAME  : capture_range.php
*! DESCRIPTION: Return frame number when the specified timestamp whil be reached 
*               or expected timestamp for the specified frame.
*               Useful to synchronize multiple camera triggered by one of them
*               when the master timestamp is sent to each camera. Normally
*               used with just the master sensor port.
*               
*! Copyright (C) 2021 Elphel, Inc
*! -----------------------------------------------------------------------------**
*!
*!  This program is free software: you can redistribute it and/or modify
*!  it under the terms of the GNU General Public License as published by
*!  the Free Software Foundation, either version 3 of the License, or
*!  (at your option) any later version.
*!
*!  This program is distributed in the hope that it will be useful,
*!  but WITHOUT ANY WARRANTY; without even the implied warranty of
*!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*!  GNU General Public License for more details.
*!
*!  You should have received a copy of the GNU General Public License
*!  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*! -----------------------------------------------------------------------------**
*!
*/
   define('CAPTURE_RANGE_STATE',        '/var/state/capture_range.state');
   set_include_path ( get_include_path () . PATH_SEPARATOR . '/www/pages/include' );
   include 'show_source_include.php';
   include "elphel_functions_include.php"; // includes curl functions
   $minahead = 2;
   $PARS_FRAMES = 16;
   $maxahead = $PARS_FRAMES - 4; // 3;
   $flags = 0;
   
   if (!($_SERVER ['REQUEST_METHOD'] == "GET")){
       //Maybe re-write this in C or as a PHP function? 
       // CLI mode will be spawned bu the CGI and run in a background after request will be over
       $sensor_port = $argv[1]; // $argv[0] - script name
       $port_mask =   $argv[2];
       $frame =       $argv[3]; // absolute frame to start compressor
       $duration =    $argv[4]; // number of frames to run compressor
       $notify =      $argv[5]; // double-quoted URL 
       
       if ($frame > 0){
           $frame +=1; // seem there is a bug - actual compressed frames numbers (and last compressed frame number) are 1 less than expected
       }
       // If 'duration'==0 - just stop compressor, if 'duration' <0 - only start, if duration >0 - start+stop
       
//       $f = fopen ( "/var/log/capture_range.log", 'a' );
//       fwrite($f,"elphel_capture_range($sensor_port, $port_mask, $frame, $duration);\n");
//       fclose ( $f );

       /**
        * Program multiple channels (according to 'port_mask') to start compressor at absolute (or relative) 'frame', run it for 'duration' frames
        * and then stop. If 'duration'==0 - just stop compressor, if 'duration' <0 - only start.
        * This function is intended to be executed in a background process (such as in capture_range.php) not to hold http client
        * BUG: frame number after stop is 2 less than expected (ahead applied in wrong place?)
        */
       elphel_capture_range($sensor_port, $port_mask, $frame, $duration);
//       $f = fopen ( "/var/log/capture_range.log", 'a' );
//       fwrite($f,"elphel_capture_range DONE\n");
       if ($notify){ // complete url with http://
           file_get_contents($notify);
       }
//       fclose ( $f );
       // can still get stuck for a long time, but testing file exists is faster that find a process
       if (file_exists(CAPTURE_RANGE_STATE)) {
           unlink(CAPTURE_RANGE_STATE);
       }
       exit(0);
   }
   $retval=-1; // not used
   
   if (count($_GET) < 1) {
       print ("CGI mode");
       // Be carefull watching that USAGE is not indented (after auto-indenting). That leads to errors such as (at much later line number)!
       // Parse error: syntax error, unexpected '' (T_ENCAPSED_AND_WHITESPACE), expecting identifier (T_STRING) or variable (T_VARIABLE)
       // or number (T_NUM_STRING) in /www/pages/capture_range.php on line 143
       echo <<<USAGE
<p>This script returns the timestamp for specified frame (frame=?) or expected frame number
  when the specified timestamp (timestamp = ?.?) will be reached. If none of the frame number
  and timestamp are specified - return last compressed frame number and timestamp.</p>
<p>Uses TRIG_PERIOD (in 10ns increments) for calculations.</p>
<p>sensor_port=0..3 - specify which sensor port to use, default is sensor_port=0</p>
USAGE;
      exit (0);
    }
    $sensor_port=0;
    $frame = 0;
    $timestamp = 0.0;
    $PARS_FRAMES = 16;
    $minahead = 2;
    $notify_args=array();
    $notify_url="";
//    $port_mask = 15; // not set - same as ts2frame.php
//    $duration =  1; // not set - end, set - start 
//    $wait = false;
    $extra = 2; // wait extra frames after stop to be sure compressor is flashed?
    foreach($_GET as $key=>$value) {
        if ($key == 'sensor_port'){
            $sensor_port = (integer) $value;
        } else if (($key == 'state')) {
            $read_state = 1; // all other parameters will not be used, maybe in the future - use multi request and combine responses?
        } else if (($key == 'a')  || ($key == 'ahead')){ // will overwrite timestamp with this value (in seconds) from now
            $ahead_now = (double) $value;
        } else if (($key == 'ts')  || ($key == 'timestamp')){
            $timestamp = (double) $value;
        } else if (($key == 'f')   || ($key == 'frame')){
            $frame = (integer) $value;
        } else if (($key == 'm')   || ($key == 'port_mask')){
//            $port_mask = (integer) $value;
            $masklist = $value;
        } else if (($key == 'd')   || ($key == 'duration')){
// TODO: make durations optionally a list, same as port mask (for EO - different)            
 // wait - apply to the first IP in a list? or to the last?           
//            $duration = (integer) $value;
            $duration_list = $value;
        } else if (($key == 'mxa') || ($key == 'maxahead')){
            $maxahead = (integer) $value;
        } else if (($key == 'mna') || ($key == 'minahead')){
            $minahead = (integer) $value;
        } else if (($key == 'w')   || ($key == 'wait')){ // wait all done
            $wait = true;
        } else if (($key == 'e')   || ($key == 'extra')){
            $extra = (integer) $value; // not used?
        } else if (($key == 'ip') || ($key == 'ips')){ //  multicamera operation
            $ips = explode(',',$value);
        } else if (substr($key,0,7) == "notify_") {
            $nk = substr($key,7);
            if ($nk == 'cmd'){
                $notify_cmd=$value;
            } else if (substr($nk,0,3) == 'key') {
                $ni = intval(substr($nk,3));
                if (!isset($notify_args[$ni])) $notify_args[$ni]=array();
                $notify_args[$ni][0] = $value;
            } else if (substr($nk,0,3) == 'val') {
                $ni = intval(substr($nk,3));
                if (!isset($notify_args[$ni])) $notify_args[$ni]=array();
                $notify_args[$ni][1] = $value;
            }
        }
    }
    //capture_range.php?sensor_port=0&state&frame=20 # will respond and block if there are fewer than 20 frames
    if (isset($read_state)) { // if $frame >0 wait if less frames are left
        $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><capture_range/>");
        // does the state file exist?
        $this_frame = 0;
        $left =       0;
        if (file_exists(CAPTURE_RANGE_STATE)) {
           $ini =  parse_ini_file(CAPTURE_RANGE_STATE);
           $end_frame = intval($ini['end_frame']); 
           $this_frame=elphel_get_frame($sensor_port);
           $left = $end_frame - $this_frame;
           if (($frame > 0) && ($left > 0) && ($left < $frame)){
               elphel_wait_frame_abs($sensor_port, $end_frame); // wait and block client
           }
           $this_frame=elphel_get_frame($sensor_port);
           $left = $end_frame - $this_frame;
        }
        $xml->addChild ('frame',$this_frame);
        $xml->addChild ('end_frame',$end_frame);
        $xml->addChild ('left',$left);
        $rslt=$xml->asXML();
        header("Content-Type: text/xml");
        header("Content-Length: ".strlen($rslt)."\n");
        header("Pragma: no-cache\n");
        printf($rslt);
        exit(0);
    }
    if (isset($notify_cmd)){ 
        $wait = false;
        $notify_url='http://'.$notify_cmd; // $notify_cmd includes full url
        $i=0;
        foreach ($notify_args as $kv) {
            if (isset($kv[0])) {
                $notify_url .= ($i ? '&' : '?');
//                $notify_url .= ($i ? '&amp;' : '?');
                $notify_url .= $kv[0];
                if (isset($kv[1])) {
                    $notify_url .= '=' . $kv[1];
                }
                $i ++;
            }
        }
    }
    
    if (isset($ahead_now)){  
        $this_frame=elphel_get_frame($sensor_port);
        $this_timestamp=elphel_frame2ts($sensor_port,$this_frame);
        $timestamp = $this_timestamp + $ahead_now;
    }
    // if ips are provided, treat port mask as commaseparated list
    //            $port_mask = (integer) $value;
    if (isset($ips)){
        $pml = explode(',', $masklist);
        $port_mask = array ();
        for ($i = 0; $i<count($ips); $i++){
            if ($i < count($pml)){
                $port_mask[] = (integer) $pml[$i];
            } else {
                $port_mask[] = 15; // default - all sensors
            }
        }
        $durl = explode(',', $duration_list);
        $duration = array();
        for ($i = 0; $i<count($ips); $i++){
            if ($i < count($durl)){
                $duration[] = (integer) $durl[$i];
            } else {
                $duration[] = $duration[0]; // at least one duration should be provided
            }
        }
    } else {
        $port_mask = (integer) $masklist;      // single valude
        $duration =  (integer) $duration_list; // single valude
    }
    
    // convert provided timestamp to integer number of frame timestamp
    if (($frame !=0) || ($timestamp !=0.0)) {
        if (($frame <=0) && ($timestamp > 0.0)){
            $frame = elphel_ts2frame($sensor_port,$timestamp);
        }
        $timestamp = elphel_frame2ts($sensor_port,$frame); // update, even if provided to fit better integer number of frames
    }
    
    if (isset($ips)){ // start parallel requests to all cameras ($ips should include this one too), collect responses and exit
        // prepare URLs
        $urls = array();
        for ($i = 0; $i<count($ips); $i++){
            // $_SERVER[SCRIPT_NAME] STARTS WITH '/'
            $url = 'http://'.$ips[$i].$_SERVER[SCRIPT_NAME].'?sensor_port='.$sensor_port; //
            $url .= '&ts='.$timestamp; // &timestamp" -> ×tamp
            $url .= '&port_mask='.$port_mask[$i];
            $url .= '&duration='. $duration[$i];
            $url .= '&maxahead='. $maxahead;
            $url .= '&minahead='. $minahead;
            $url .= '&extra='.    $extra;
            if ($wait && ($i == (count($ips) - 1))){ // addd to the last ip in a list
                $url .= '&wait';
            }
            $urls[] = $url;
        }
//        print_r($urls);
//        exit(0);
        $curl_data = curl_multi_start ($urls);
        $enable_echo = false;
        $results =  curl_multi_finish($curl_data, true, 0, $enable_echo); // Switch true -> false if errors are reported (other output damaged XML)
        $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><capture_range/>");
        for ($i = 0; $i<count($ips); $i++){
            $xml_ip = $xml->addChild ('ip_'.$ips[$i]);
            foreach ($results[$i] as $key=>$value){
                $xml_ip->addChild($key,$value);
            }
        }
        $rslt=$xml->asXML();
        header("Content-Type: text/xml");
        header("Content-Length: ".strlen($rslt)."\n");
        header("Pragma: no-cache\n");
        printf($rslt);
        exit(0);
    }
    
    
    $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><capture_range/>");
        $flags = 0;
    $use_daemon = ($frame != 0);
    if (isset($port_mask)) { // start or stop compressor
        $this_frame = elphel_get_frame($sensor_port);
        if (! $use_daemon) { // e.g. to stop ASAP $frame=0, $duration !=0 - start ASAP
            if ($duration < 0) {
                elphel_compressor_run($sensor_port, 0, $flags, $port_mask); // turn on ASAP
                $xml->addChild('compressor', 1);
            } else { // frame = 0; duration ==0 - stop ASAP
                elphel_compressor_stop($sensor_port, 0, $flags, $port_mask); // turn off ASAP
                $xml->addChild('compressor', 0);
            }
            $frame = $this_frame + $minahead;
        } 
        $ahead = $frame - $this_frame;
        if ($use_daemon && ($ahead < $minahead) && (!isset($ahead_now))) {
            $xml->addChild('error', 'TOO LATE');
            $xml->addChild('ahead', $ahead);
        } else { // OK, enough time to program or no-daemon mode, or ASAP
            if (! isset($duration)) {
                $duration = 0;
            }
            // kill CLI mode if it was running (e.g. waiting for 100 years) first check file exists (faster)
//            if (file_exists(CAPTURE_RANGE_STATE) || getPIDByName('capture_range.php', 'php', $active_only = false)) {
            if (file_exists(CAPTURE_RANGE_STATE)) { // getPIDByName('capture_range.php', 'php', $active_only = false) is slower
               exec("killall capture_range.php", $output, $retval); // grows lighttpd_stderr.log, need to check before kill
               unlink(CAPTURE_RANGE_STATE);
            }
            // spawn CLI program in background duration <0 - start only, ==0 - stop only, >0 - start+stop
            // $f = fopen ( "/var/log/capture_range.log", 'a' );
            // fwrite($f,"exec(/www/pages/capture_range.php $sensor_port $port_mask $frame $duration > /dev/null 2>&1 &\n");
            // fclose ( $f );
            // if ($notify_url) {
            // $xml->addChild ('notify_url', $notify_url); // urlencode($notify_url)); // dry run, do nothing
            // } else {
            if ($use_daemon) {
                if (isset($ahead_now) && ($ahead_now == 0)){
                    $frame = 0; // ASAP
                }
                $end_frame = $frame;
                if ($duration > 0) {
                    $end_frame += $duration; // xml will contain end frame
                }
                file_put_contents(CAPTURE_RANGE_STATE, "end_frame = $end_frame\n");
                exec("/www/pages/capture_range.php $sensor_port $port_mask $frame $duration '$notify_url'> /dev/null 2>&1 &");
                // }
                // $f = fopen ( "/var/log/capture_range.log", 'a' );
                // fwrite($f,"DONE exec\n");
                // fclose ( $f );
                if ($wait) {
                    elphel_wait_frame_abs($sensor_port, $frame + 1);
                }
            } else {
                if (file_exists(CAPTURE_RANGE_STATE)) {
                    unlink(CAPTURE_RANGE_STATE);
                }
            }
        }
    } else { // just ts2frame.php mode
        if ($frame == 0) {
            $timestamp = elphel_frame2ts($sensor_port, 0);
            $frame = elphel_ts2frame($sensor_port, 0.0);
        }
    }
    $xml->addChild ('retval', $retval);
    $xml->addChild ('frame',$frame);
    $xml->addChild ('timestamp',$timestamp);
    $this_frame=elphel_get_frame($sensor_port);
    $xml->addChild ('this_frame',$this_frame);
    $xml->addChild ('this_timestamp',elphel_frame2ts($sensor_port,$this_frame));
//    $xml->addChild ('frame',$frame);
//    $xml->addChild ('timestamp',$timestamp);
    
    $rslt=$xml->asXML();
    header("Content-Type: text/xml");
    header("Content-Length: ".strlen($rslt)."\n");
    header("Pragma: no-cache\n");
    printf($rslt);
?>
