<?php

include "../include/elphel_functions_include.php";
define('CONF_LWIR16',        '/etc/elphel393/lwir16.ini');
define('IPS',                'ips');
define('PORT_MASKS',         'port_masks');
define('RUN_MODES',          'run_modes');
// OR-ed: 49 - master LWIR RAW, 33 - slave LWIR RAW, 42 - continuously-run slave EO RAW, 4 - slave IMS logger, file system
define('RUN_MODE_LWIR',      1);
define('RUN_MODE_EO',        2);
define('RUN_MODE_IMS',       4);
define('RUN_MODE_CONT',      8); // continuously run from start to stop
define('RUN_MODE_MASTER',   16);
define('RUN_MODE_RAWREC',   32); // raw recording, 0 - use file system

define('NUM_PORTS',          4);
define('IMGSRV_PORT0',       2323);
define('PORTSPATH',          '/sys/devices/soc0/elphel393-detect_sensors@0');
define('MULTICAM_INI',       'multicam_ini');
define('MULTICAM_DIR',       'multicam_dir');
define('MULTICAM_RPERIOD',   'multicam_rperiod');
define('MULTICAM_SPERIOD',   'multicam_speriod');
define('MULTICAM_CONF',      'multicam_conf');

if (isset($_GET['cmd']))
    $cmd = $_GET['cmd'];
else if (isset($argv[1]))
    $cmd = $argv[1];
        

// allow CORS
header('Access-Control-Allow-Origin: *');

// does not need configs
switch($cmd){
    case "ports":
        send_response(getports());
        exit (0);
}

getIni(); 

switch($cmd){
  case "ips":
      send_response(getIps());
      exit (0);
  case "update": 
      foreach($_GET as $key=>$value) {
          if (array_key_exists($key, $GLOBALS[MULTICAM_INI])){
              $GLOBALS[MULTICAM_INI][$key] = $value;
          }
      }
      writeConfig();
      exitXmlOK();
  case "configs": // return xml with all $GLOBALS[MULTICAM_INI]
      send_response(getConfigs());
      exit(0);
      
  default:
      exitXmlOK("Unknown");
}


function getIni() {
    $ini=    parse_ini_file(CONF_LWIR16);
    applyConf($ini);
    $GLOBALS[MULTICAM_INI][MULTICAM_DIR] =      $ini[MULTICAM_DIR];
    $GLOBALS[MULTICAM_INI][MULTICAM_RPERIOD] =  $ini[MULTICAM_RPERIOD];
    $GLOBALS[MULTICAM_INI][MULTICAM_SPERIOD] =  $ini[MULTICAM_SPERIOD];
//    $GLOBALS[MULTICAM_INI][MULTICAM_CONF] =     $ini[MULTICAM_CONF];
    $GLOBALS[MULTICAM_CONF]                =    $ini[MULTICAM_CONF];
    // copy other default parameters
    // try to read xml if exists
    $multi_xml = 0;
    if (file_exists($ini[MULTICAM_CONF])) {
        $multi_xml = simplexml_load_file($ini[MULTICAM_CONF]);
    }
    if ($multi_xml) { // if file exists
        $multi_ini = array();
        foreach ( $multi_xml->children () as $entry ) {
            $GLOBALS[MULTICAM_INI][$entry->getName ()] = (string) $entry;
        }
    } else {
        writeConfig();
    }
    setIPs();
}
// encoding='iso-8859-1'
function writeConfig(){
    $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><multicam/>");
    foreach($GLOBALS[MULTICAM_INI] as $key=>$value){
        $xml->addChild($key,   $value);
    }
    file_put_contents($GLOBALS[MULTICAM_CONF],$xml->asXML());
    exec('sync');
    /*
    print ("<!--\n");
    print("WRITING to ".$GLOBALS[MULTICAM_INI][MULTICAM_CONF]."\n");
    print($xml);
    print ("-->");
    */
}

function printToComment($str) {
    echo "<!--".$str."-->";
}

function getConfigs(){
    $xml = new SimpleXMLElement("<?xml version='1.0' standalone='yes'?><configs/>");
    $xml->addChild(MULTICAM_DIR,     $GLOBALS[MULTICAM_INI][MULTICAM_DIR]);
    $xml->addChild(MULTICAM_RPERIOD, $GLOBALS[MULTICAM_INI][MULTICAM_RPERIOD]);
    $xml->addChild(MULTICAM_SPERIOD, $GLOBALS[MULTICAM_INI][MULTICAM_SPERIOD]);
    return $xml;
}



function getports(){
  $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><camera/>");
  for($i=0;$i<NUM_PORTS;$i++){
      $sensor = PORTSPATH."/sensor{$i}0";
    // the file is always there actually
    if(is_file($sensor)){
      $c = trim(file_get_contents($sensor));
      $p = IMGSRV_PORT0+$i;
      $xp= $xml->addChild('port',     $c);
      $xp->addAttribute('index', $i);
      $xp->addAttribute('port', $p);
    }
  }
  return $xml;
}

function getIps(){
    $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><camera/>");
    for($i=0;$i< count($GLOBALS[IPS]);$i++){
        $xp= $xml->addChild('ip',    $GLOBALS[IPS][$i]);
        $xp->addAttribute('index', $i);
        $xp->addAttribute(PORT_MASKS, $GLOBALS[PORT_MASKS][$GLOBALS[IPS][$i]]);
        $xp->addAttribute(RUN_MODES, $GLOBALS[RUN_MODES][$GLOBALS[IPS][$i]]);
    }
    return $xml;
}

function exitXmlOK($str="ok"){
    $xml = new SimpleXMLElement("<?xml version='1.0'  standalone='yes'?><$str/>");
    send_response($xml);
    exit(0);
}

function applyConf($arr){ // not used at all
    //port_masks=  "15,15,15,15,15"
    if (isset($arr[IPS])) {
        $GLOBALS[IPS] =        explode(',',$arr[IPS]);
        if (isset ($arr[PORT_MASKS])){
            $masks = explode(',',$arr[PORT_MASKS]);
        }
        if (isset ($arr[RUN_MODES])){
            $run_modes = explode(',',$arr[RUN_MODES]);
        }
        // Add port masks incdexed by IPs. Changing IPs resets masks
        $GLOBALS[PORT_MASKS] = array();
        $GLOBALS[RUN_MODES] = array();
        for ($i = 0; $i < count($GLOBALS[IPS]); $i++){
            if (isset($masks) && (count($masks) > $i)){
                $GLOBALS[PORT_MASKS][$GLOBALS[IPS][$i]] = (int) $masks[$i];
            } else {
                $GLOBALS[PORT_MASKS][$GLOBALS[IPS][$i]] = ALL_PORTS;
            }
            if (isset($run_modes) && (count($run_modes) > $i)){
                $GLOBALS[RUN_MODES][$GLOBALS[IPS][$i]] = (int) $run_modes[$i];
            } else {
                $GLOBALS[RUN_MODES][$GLOBALS[IPS][$i]] = 0;
            }
        }
        setIPs(); // set ip arrays ($GLOBALS[IP_LWIR], ...) that depend on RUN_MODES
    }
}

function setIPs(){
    $GLOBALS[IP_LWIR]=     array();
    $GLOBALS[IP_EO]=       array();
    $GLOBALS[IP_CAMERAS]=  array();
    $GLOBALS[IP_MASTER]=   array(); // normally just one, use [0]
    $GLOBALS[IP_IMS]=      array(); // normally just one, use [0]
    foreach ($GLOBALS[RUN_MODES] as $ip => $smode){
        $mode = intval($smode); // just in case, should already be integer
        if ($mode & RUN_MODE_MASTER) {
            $GLOBALS[IP_MASTER][] =  $ip; // use [0]
        }
        if ($mode & RUN_MODE_LWIR) {
            $GLOBALS[IP_LWIR][] =    $ip;
            $GLOBALS[IP_CAMERAS][] = $ip;
        }
        if ($mode & RUN_MODE_EO) {
            $GLOBALS[IP_EO][] =      $ip;
            $GLOBALS[IP_CAMERAS][] = $ip;
        }
        if ($mode & RUN_MODE_IMS) {
            $GLOBALS[IP_IMS] =       $ip;
        }
    }
}

function send_response($xml){
    $rslt=$xml->asXML();
    header("Content-Type: text/xml");
    header("Content-Length: ".strlen($rslt)."\n");
    header("Pragma: no-cache\n");
    printf($rslt);
    flush();
}



function send_zipped_images($ips){



}

?>