__author__ = "Elphel"
__copyright__ = "Copyright 2016, Elphel, Inc."
__license__ = "GPL"
__version__ = "3.0+"
__maintainer__ = "Oleg K Dzhimiev"
__email__ = "oleg@elphel.com"
__status__ = "Development"

import os
import re
import subprocess
import time
import tempfile
import shutil
import requests

def shout(cmd):
  #subprocess.call prints to console
  #subprocess.call(cmd,shell=True)
  ret_str = ""
  try:
    ret_str = subprocess.check_output(cmd,shell=True).decode('ISO-8859-1')
  except subprocess.CalledProcessError as e:
    ret_str = str(e.returncode)
  return ret_str

#http://stackoverflow.com/questions/287871/print-in-terminal-with-colors-using-python
class bcolors:
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKGREEN = '\033[92m'
    WARNING = '\033[38;5;214m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    BOLDWHITE = '\033[1;37m'
    UNDERLINE = '\033[4m'

class Camera:
  def __init__(self,user="root",ip="192.168.0.9"):
    self.user = user
    self.ip = ip
    self.sshcmd = "ssh "+user+"@"+ip
    self.scpcmd = "scp "+user+"@"+ip+":"
    self.lanurl = "http://"+ip+":2323/ssd"
    self.disable = False
    self.pattern = "ata-"
    self.check_connection()
    
  def check_connection(self):
    check = shout(self.sshcmd+" 'dmesg'")
    if check.strip() == str(255):
      self.disable = True
    else:
      print(self.user+"@"+self.ip+": connection ok")
  
  def ssd_to_pc(self):
    self.unmount_all()
    self.unload_ahci_driver()
    self.mux_ssd_to_esata()
    print(self.user+"@"+self.ip+": Enabled connection: internal SSD <-> PC")
  
  def ssd_to_camera(self):
    self.load_ahci_driver()
    self.mux_ssd_to_cpu()
    print(self.user+"@"+self.ip+": Enabled connection: internal SSD <-> Camera")
  
  def partition_name(self,partition=""):
    if partition!="":
      res = shout(self.sshcmd+" 'ls -all /dev/disk/by-id | grep '"+self.pattern+"' | grep '"+partition[-4:]+"''")
      if res!="1":
        for name in res.split(" "):
          if name[0:len(self.pattern)]==self.pattern:
            return name[len(self.pattern):]
    return "undefined"
  
  def list_partitions(self):
    res = shout(self.sshcmd+" 'cat /proc/partitions'")
    plist = []
    for line in res.splitlines():
      s0 = re.search('sd[a-z][0-9]',line)
      if s0:
        plist.append(s0.group(0))
      else:
        s0 = re.search('sd[a-z]',line)
        if s0:
          plist.append(s0.group(0))
    return plist
  
  def list_partitions_as_host(self):
    res = shout(self.sshcmd+" 'ls /dev/disk/by-id/ -all ' | grep '"+self.pattern+"'")
    plist = []
    for line in res.splitlines():
      items = line.split(" ")
      for name in items:
        if name[0:len(self.pattern)]==self.pattern:
          item = items[-1].split("/")
          plist.append([name[len(self.pattern):],item[-1]])
    return plist
  
  
  def list_mounted_partitions(self):
    res = shout(self.sshcmd+" 'df -h'")
    df_list = []
    for line in res.splitlines():
      s0 = re.search('sd[a-z][0-9]',line)
      if s0:
        df_list.append(s0.group(0))
    return df_list
  
  # combine with list_partitions?
  def list_blkid(self):
    res = shout(self.sshcmd+" 'blkid'")
    blist = []
    for line in res.splitlines():
      s0 = re.search('sd[a-z][0-9]',line)
      if s0:
        s1 = re.search('TYPE=',line)
        if s1:
          blist.append(s0.group(0))
    return blist
  
  def list_raw_partitions(self):
    plist = self.list_partitions()
    blist = self.list_blkid()
        
    for p in plist:
      if p in blist:
        plist.remove(p)
        plist.remove(p[0:-1])
    
    return plist
  
  def first_found_raw_partition(self):
    plist = self.list_raw_partitions()
    if len(plist)!=0:
      return "/dev/"+plist[0]
    else:
      return ""
  
  def first_found_raw_partition_name(self):
    p = self.first_found_raw_partition()
    return self.partition_name(p)
  
  def mux_ssd_to_esata(self):
    shout(self.sshcmd+" '/usr/local/bin/x393sata_control.py set_esata_ssd'")

  def mux_ssd_to_cpu(self):
    shout(self.sshcmd+" '/usr/local/bin/x393sata_control.py set_zynq_ssd'")

  def device_partitions(self,device):
    test = shout(self.sshcmd+" 'ls /dev/disk/by-id/ -all'")
    return test

  def unmount_all(self):
    blist = self.list_mounted_partitions()
    if len(blist)==0:
      print("umount: ok")
    else:
      for b in blist:
        print("umounting /dev/"+b)
        self.unmount("/dev/"+b)
      
  def unmount(self,partition):
    shout(self.sshcmd+" 'umount "+partition+"'")

  def unload_ahci_driver(self):
    shout(self.sshcmd+" 'rmmod ahci_elphel'")
  
  def load_ahci_driver(self):
    subprocess.Popen(self.sshcmd+" 'modprobe ahci_elphel'",shell=True)
    time.sleep(1)
    shout(self.sshcmd+" 'echo 1 > /sys/devices/soc0/amba@0/80000000.elphel-ahci/load_module'")

  def read_camogm_disk_file_blocks(self, part,fname="camogm.disk"):
    print("camera: read_camogm_disk_file_blocks() "+fname+ "self.scpcmd="+self.scpcmd)
    result = 0
    tmp_mount_point = tempfile.mkdtemp()
    print(self.scpcmd+"/mnt/"+part+"/"+fname+" "+tmp_mount_point)
    shout(self.scpcmd+"/mnt/"+part+"/"+fname+" "+tmp_mount_point)
    try:
      with open (tmp_mount_point+"/"+fname, "r") as myfile:
        print ("Opened "+tmp_mount_point+"/"+fname)  
        data=myfile.readlines()
        if len(data)==2:
          l2 = data[1]
          pointers = l2.split("\t")
          pntr1 = int(pointers[1])
          pntr2 = int(pointers[2])
          result = pntr2-pntr1
    except IOError:
      print(tmp_mount_point+"/"+fname+" NOT FOUND")
#    os.rmdir(tmp_mount_point)
    shutil.rmtree(tmp_mount_point, ignore_errors=True) # non-empty, may contain read-only    
    return result

class PC():
  def __init__(self):
    self.pattern = "ata-"
  
  def list_partitions(self):
    res = shout("ls /dev/disk/by-id/ -all | grep '"+self.pattern+"'")
    plist = []
    for line in res.splitlines():
      items = line.split(" ")
      for name in items:
        if name[0:len(self.pattern)]==self.pattern:
          item = items[-1].split("/")
          plist.append([name[len(self.pattern):],item[-1]])
    return plist

  # mounts partition (/dev/sd?1), reads camogm.disk file
  # returns the download size from raw partition ((/dev/sd?2))
  def read_camogm_disk_file(self,part,fname="camogm.disk"):
    print("read_camogm_disk_file() "+fname)
    result = 0
    tmp_mount_point = tempfile.mkdtemp()
    print("mounting "+part+" to "+tmp_mount_point)
    shout("sudo mount "+part+" "+tmp_mount_point)
    print("mounted "+part+" to "+tmp_mount_point)
    time.sleep(1)
    try:
      with open (tmp_mount_point+"/"+fname, "r") as myfile:
        data=myfile.readlines()
        if len(data)==2:
          l2 = data[1]
          pointers = l2.split("\t")
          pntr1 = int(pointers[1])
          pntr2 = int(pointers[2])
          result = float(pntr2-pntr1)*512/1024/1024/1024 # still 512 block size
    except IOError:
      print(tmp_mount_point+"/"+fname+" NOT FOUND")
    shout("sudo umount "+tmp_mount_point)
    os.rmdir(tmp_mount_point)
    return result

#similar as read_camogm_disk_file(), but uses LAN istead of eSATA. Needs additional argument ip
  def read_camogm_disk_file_lan(self, ip, part, fname="camogm.disk"):
    result = 0
    tmp_mount_point = tempfile.mkdtemp()
    print("scp root@"+ip+":/mnt/"+part+"/"+fname+" "+tmp_mount_point)
    shout("scp root@"+ip+":/mnt/"+part+"/"+fname+" "+tmp_mount_point)
    try:
      with open (tmp_mount_point+"/"+fname, "r") as myfile:
        data=myfile.readlines()
        if len(data)==2:
          l2 = data[1]
          pointers = l2.split("\t")
          pntr1 = int(pointers[1])
          pntr2 = int(pointers[2])
          result = float(pntr2-pntr1)*512/1024/1024/1024 # still 512 block size
    except IOError:
      print(tmp_mount_point+"/"+fname+" NOT FOUND")
#    os.rmdir(tmp_mount_point)
    shutil.rmtree(tmp_mount_point, ignore_errors=True) # non-empty, may contain read-only    
    return result


  """
  Returns block offset from the start of partition to the current LBA pointer
  """
  def read_camogm_disk_file_blocks(self,part,fname="camogm.disk"):
#    print("PC: read_camogm_disk_file_blocks() "+fname)
    result = 0
    tmp_mount_point = tempfile.mkdtemp()
    print("mounting "+part+" to "+tmp_mount_point)
    shout("sudo mount "+part+" "+tmp_mount_point)
    print("mounted "+part+" to "+tmp_mount_point)
    time.sleep(1)
#    print ("Opening "+tmp_mount_point+"/"+fname)
#    time.sleep(100);
    try:
      with open (tmp_mount_point+"/"+fname, "r") as myfile:
#        print("reading "+tmp_mount_point+"/"+fname)  
        data=myfile.readlines()
#       print("len(data)= "+str(len(data)))
        if len(data)==2:
          l2 = data[1]
          pointers = l2.split("\t")
          pntr1 = int(pointers[1])
          
          pntr2 = int(pointers[2])
#          result = float(pntr2-pntr1)*512/1024/1024/1024
          result = pntr2-pntr1
    except IOError:
      print(tmp_mount_point+"/"+fname+" NOT FOUND")
    shout("sudo umount "+tmp_mount_point)
    os.rmdir(tmp_mount_point)
    return result

  def read_camogm_disk_file_blocks_lan(self, ip, part,fname="camogm.disk"):
    result = 0
    tmp_mount_point = tempfile.mkdtemp()
    print("scp root@"+ip+":/mnt/"+part+"/"+fname+" "+tmp_mount_point)
    shout("scp root@"+ip+":/mnt/"+part+"/"+fname+" "+tmp_mount_point)
    try:
      with open (tmp_mount_point+"/"+fname, "r") as myfile:
#        print("reading "+tmp_mount_point+"/"+fname)  
        data=myfile.readlines()
#        print("len(data)= "+str(len(data)))
        if len(data)==2:
          l2 = data[1]
          pointers = l2.split("\t")
          pntr1 = int(pointers[1])
          pntr2 = int(pointers[2])
#          result = float(pntr2-pntr1)*512/1024/1024/1024
          result = pntr2-pntr1
    except IOError:
      print(tmp_mount_point+"/"+fname+" NOT FOUND")
#    os.rmdir(tmp_mount_point)
    shutil.rmtree(tmp_mount_point, ignore_errors=True) # non-empty, may contain read-only    
    return result

  def is_raw(self,part):
    res = shout("sudo blkid | grep "+str(part))
    typ = " TYPE=" # added space, otherwise: /dev/sdd2: PTTYPE="atari" PARTUUID="e174570b-02"
    s0 = re.search(typ,res)
    if s0:
      fstype = ""
      pars = res.split(" ")
      for par in pars:
        if par[0:len(typ)]==typ:
          fstype = par[len(typ):]
          break
      
      print(part+" partition has a filesystem: "+fstype)
      
      raise Exception(bcolors.FAIL+"Partition has a filesystem ("+fstype+"): mount and copy files manually"+bcolors.ENDC)

  def download(self,dest,part,dl_bs=20,dl_bc=512,dl_skip=0,dl_n=0):

    self.is_raw(part)

    print("Getting raw partition data from "+part)
    
    if not os.path.isdir(dest):
      os.mkdir(dest)
    
    dirname = self.partname(part)
    
    if dirname!="":
      dirname = dest+"/"+dirname
      if not os.path.isdir(dirname):
        os.mkdir(dirname)
      for i in range(0,dl_n+dl_skip):
#        fname = dirname+"/"+"file_"+str(i)+".img"
        fname = "%s/file_%03d.img" %(dirname, i) #dirname+"/"+"file_"+str(i)+".img"
        skip = i*(dl_bc-1)
        if i>=dl_skip:
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(dl_bs)+"M count="+str(dl_bc)+" skip="+str(skip))
      
  def download_blocks(self, dest, part, blocks_load, blocks_skip= 0, file_gb=10, chunk_blocks=32768, block_size=512): #4096):
    chunk_bytes =  block_size * chunk_blocks 
    file_chunks =  (file_gb * 1024 * 1024 * 1024) // chunk_bytes
    self.is_raw(part)
    print("Getting raw partition data from "+part)
    if not os.path.isdir(dest):
      os.mkdir(dest)
    dirname = self.partname(part)
    if dirname!="":
      dirname = dest+"/"+dirname
      if not os.path.isdir(dirname):
        os.mkdir(dirname)
      num_file = 0
      # optional first file to align skip to chunk_blocks, 1 block at a time
      if (blocks_skip > 0) and ((blocks_skip % chunk_blocks) > 0):
        bwrite = chunk_blocks - (blocks_skip % chunk_blocks)
        if (bwrite > blocks_load):
          bwrite = blocks_load
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        
        print("Aligning skip to chunks, downloading %d %d-byte blocks (skipping %d blocks) to %s"%(bwrite, block_size, blocks_skip, fname))
        shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip))
        blocks_skip += bwrite
        blocks_load -= bwrite
        num_file += 1
      # write bulk of the blocks, <= file_chunks of chunks in each file
      while ((blocks_load // chunk_blocks)  > 0):
        chunks_write = blocks_load // chunk_blocks
        chunks_skip = blocks_skip // chunk_blocks # should be already multiple of chunks
        if (chunks_write > file_chunks):
          chunks_write = file_chunks
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Downloading %d %d-byte chunks, skipping %d chunks to %s"%(chunks_write, chunk_bytes, chunks_skip, fname))
        print("sudo dd if="+part+" "+" of="+fname+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip))
        shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip))
        bwrite = chunks_write * chunk_blocks
        blocks_skip += bwrite
        blocks_load -= bwrite
        num_file += 1
      # optionally write the remainder (< chunk), 1 block at a time
      if (blocks_load > 0):
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Downloading last %d %d-byte blocks, skipping %d blocks to %s"%(blocks_load, block_size, blocks_skip, fname))
        shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip))

#time ssh root@192.168.0.41 "dd if=/dev/sda2 bs=16777216 count=409 skip=322" | dd of=/home/elphel/lwir16-proc/test_dd/file_0001.img
#     res = shout(self.sshcmd+" 'ls -all /dev/disk/by-id | grep '"+self.pattern+"' | grep '"+partition[-4:]+"''")
#slow, replaced by download_blocks_lan using modified imgsrv 2023-08-02
  def download_blocks_ssh(self, cam, dest, part, blocks_load, blocks_skip= 0, file_gb=10, chunk_blocks=32768, block_size=512): #4096):
    chunk_bytes =  block_size * chunk_blocks 
    file_chunks =  (file_gb * 1024 * 1024 * 1024) // chunk_bytes
    if (cam==None):
        self.is_raw(part)
        ip = None
    else:
        print("TODO: Implement raw partition check over SSH")
#        print(cam)
        ip = cam["ip"]    
    print("Getting raw partition data from "+part)
    if not os.path.isdir(dest):
      os.mkdir(dest)
    dirname = self.partname(part)
    if dirname!="":
      dirname = dest+"/"+dirname
      if not os.path.isdir(dirname):
        os.mkdir(dirname)
      num_file = 0
      # optional first file to align skip to chunk_blocks, 1 block at a time
      if (blocks_skip > 0) and ((blocks_skip % chunk_blocks) > 0):
        bwrite = chunk_blocks - (blocks_skip % chunk_blocks)
        if (bwrite > blocks_load):
          bwrite = blocks_load
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Aligning skip to chunks, downloading %d %d-byte blocks (skipping %d blocks) to %s"%(bwrite, block_size, blocks_skip, fname))
        if (cam == None):
          print("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip))
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip))
        else:
          print(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip)+"' | dd of="+fname)
          shout(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip)+"' | dd of="+fname)
        blocks_skip += bwrite
        blocks_load -= bwrite
        num_file += 1
      # write bulk of the blocks, <= file_chunks of chunks in each file
      while ((blocks_load // chunk_blocks)  > 0):
        chunks_write = blocks_load // chunk_blocks
        chunks_skip = blocks_skip // chunk_blocks # should be already multiple of chunks
        if (chunks_write > file_chunks):
          chunks_write = file_chunks
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Downloading %d %d-byte chunks, skipping %d chunks to %s"%(chunks_write, chunk_bytes, chunks_skip, fname))
        if (ip == None):
          print("sudo dd if="+part+" "+" of="+fname+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip))
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip))
        else:
          print(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip)+"' | dd of="+fname)
          shout(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip)+"' | dd of="+fname)
        bwrite = chunks_write * chunk_blocks
        blocks_skip += bwrite
        blocks_load -= bwrite
        num_file += 1
      # optionally write the remainder (< chunk), 1 block at a time
      if (blocks_load > 0):
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Downloading last %d %d-byte blocks, skipping %d blocks to %s"%(blocks_load, block_size, blocks_skip, fname))
        if (ip == None):
          print("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip))
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip))
        else:  
          print(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip)+"' | dd of="+fname)
          shout(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip)+"' | dd of="+fname)

  def download_with_imgsrv(self, cam, out_file, offs, count ):
    #    self.lanurl = "http://"+ip+":2323/ssd"
    url= cam['obj'].lanurl+str(offs)+":"+str(count)
    print("url="+url)
    with requests.get(url, stream=True) as r:
        r.raise_for_status()
        with open(out_file, 'wb') as f:
            for chunk in r.iter_content(chunk_size=8192): 
                # If you have chunk encoded response uncomment if
                # and set chunk_size parameter to None.
                #if chunk: 
                f.write(chunk)

  def download_blocks_lan(self, cam, dest, part, blocks_load, blocks_skip= 0, file_gb=10, chunk_blocks=32768, block_size=512): #4096):
    chunk_bytes =  block_size * chunk_blocks 
    file_chunks =  (file_gb * 1024 * 1024 * 1024) // chunk_bytes
    if (cam==None):
        self.is_raw(part)
        ip = None
    else:
        print("TODO: Implement raw partition check over SSH")
#        print(cam)
        ip = cam["ip"]    
    if not os.path.isdir(dest):
      os.mkdir(dest)
    print("Getting raw partition data from "+part+" to "+dest) #/dev/sda2
    if (cam==None):
      dirname = self.partname(part)
    else:
      dirname = cam['obj'].partition_name(part)   
    print ("dirname="+dirname)
#    print ("partition_name="+cam['obj'].partition_name(part))
    if dirname!="":
      dirname = dest+"/"+dirname
      if not os.path.isdir(dirname):
        os.mkdir(dirname)
      num_file = 0
      # optional first file to align skip to chunk_blocks, 1 block at a time
      if (blocks_skip > 0) and ((blocks_skip % chunk_blocks) > 0):
        bwrite = chunk_blocks - (blocks_skip % chunk_blocks)
        if (bwrite > blocks_load):
          bwrite = blocks_load
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Aligning skip to chunks, downloading %d %d-byte blocks (skipping %d blocks) to %s"%(bwrite, block_size, blocks_skip, fname))
        if (cam == None):
          print("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip))
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip))
        else:
#          print(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip)+"' | dd of="+fname)
#          shout(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(bwrite)+" skip="+str(blocks_skip)+"' | dd of="+fname)
          self.download_with_imgsrv(cam, fname, blocks_skip * block_size, bwrite * block_size )          
        blocks_skip += bwrite
        blocks_load -= bwrite
        num_file += 1
      # write bulk of the blocks, <= file_chunks of chunks in each file
      while ((blocks_load // chunk_blocks)  > 0):
        chunks_write = blocks_load // chunk_blocks
        chunks_skip = blocks_skip // chunk_blocks # should be already multiple of chunks
        if (chunks_write > file_chunks):
          chunks_write = file_chunks
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Downloading %d %d-byte chunks, skipping %d chunks to %s"%(chunks_write, chunk_bytes, chunks_skip, fname))
        if (ip == None):
          print("sudo dd if="+part+" "+" of="+fname+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip))
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip))
        else:
#         print(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip)+"' | dd of="+fname)
#         shout(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(chunk_bytes)+" count="+str(chunks_write)+" skip="+str(chunks_skip)+"' | dd of="+fname)
          self.download_with_imgsrv(cam, fname, chunks_skip * chunk_bytes, chunks_write * chunk_bytes )          
        bwrite = chunks_write * chunk_blocks
        blocks_skip += bwrite
        blocks_load -= bwrite
        num_file += 1
      # optionally write the remainder (< chunk), 1 block at a time
      if (blocks_load > 0):
#        fname = dirname+"/"+"file_"+str(num_file)+".img"
        fname = "%s/file_%03d.img" %(dirname, num_file) #dirname+"/"+"file_"+str(num_file)+".img"
        print("Downloading last %d %d-byte blocks, skipping %d blocks to %s"%(blocks_load, block_size, blocks_skip, fname))
        if (ip == None):
          print("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip))
          shout("sudo dd if="+part+" "+" of="+fname+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip))
        else:  
#          print(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip)+"' | dd of="+fname)
#         shout(cam['obj'].sshcmd+" 'dd if="+part+" bs="+str(block_size)+" count="+str(blocks_load)+" skip="+str(blocks_skip)+"' | dd of="+fname)
          self.download_with_imgsrv(cam, fname, blocks_skip * block_size, blocks_load * block_size )          
          
  def partname(self,partition):
    cmd = "ls /dev/disk/by-id/ -all | grep '"+self.pattern+"' | grep '"+partition[-4:]+"'"
    res = shout(cmd)
    for name in res.split(" "):
      if name[0:len(self.pattern)]==self.pattern:
        return name[len(self.pattern):]
    return "" 

